\name{geodesic_path}
\alias{geodesic_path}
\title{Generate geodesic path.}
\usage{geodesic_path(current, target, frozen)}

\description{
  Generate geodesic path.
}

\details{
  Wrap basis generation method with a function that keeps
  computes the geodesic interpolation from the previous
  frame to the next frame, and provides convenient access
  to all the information about the path.

  Frozen variables allow us to keep certain values of the
  projection fixed and generate a geodesic across the
  subspace generated by those
}
\keyword{internal}
\value{\item{interpolate}{A function with single parameter in [0, 1] that 
returns an interpolated frame between the current and future frames.
0 gives the current plane, 1 gives the new target frame in plane of 
current frame.}
\item{dist}{The distance, in radians, between the current and target 
frames.}
\item{Fa}{The current frame.}
\item{Fz}{The new target frame.}
\item{tau}{The principle angles between the current and target frames.}
\item{Ga}{The current plane.}
\item{Gz}{The target plane.}}
\arguments{
  \item{new_target_f}{function that generates new frame, with previous 
frame as argument}
}
\examples{a <- basis_random(4, 2)
b <- basis_random(4, 2)
path <- geodesic_path(a, b)

path$dist
all.equal(a, path$interpolate(0))
# Not true generally - a rotated into plane of b
all.equal(b, path$interpolate(1))}
