% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_census_and_acs.R
\name{search_tablecontents}
\alias{search_tablecontents}
\title{Search table contents in data files}
\usage{
search_tablecontents(survey, keyword = "*", year = NULL, view = TRUE)
}
\arguments{
\item{survey}{either "decennial" for decenial or "acs" or American Community Survey.}

\item{keyword}{keyword to be searched}

\item{year}{ending year of the survey}

\item{view}{display the search result with View if TRUE}
}
\value{
A data.table
}
\description{
Search in lookup datasets of each survey to find references of
for table_contents argument in function \code{\link{read_decennial}},
\code{\link{read_acs1year}}, and \code{\link{read_acs5year}}.
}
\examples{
# Change view = TRUE (default) to View the returned data.
# search by what you want
aaa <- search_tablecontents("decennial", "federal prison", view = FALSE)

# search by table reference
bbb <- search_tablecontents("acs", "B02003", view = FALSE)

\dontrun{
  # view all decennial census table contents
  search_tablecontents("decennial")

  # view all ACS table contents
  search_tablecontents("acs")
}

}
