% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_matrix_rank}
\alias{linalg_matrix_rank}
\title{Computes the numerical rank of a matrix.}
\usage{
linalg_matrix_rank(A, tol = NULL, hermitian = FALSE)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, m, n)} where \code{*} is zero or more
batch dimensions.}

\item{tol}{(float, Tensor, optional): the tolerance value. See above for
the value it takes when \code{NULL}. Default: \code{NULL}.}

\item{hermitian}{(bool, optional): indicates whether \code{A} is Hermitian if complex
or symmetric if real. Default: \code{FALSE}.}
}
\description{
The matrix rank is computed as the number of singular values
(or eigenvalues in absolute value when \code{hermitian = TRUE})
that are greater than the specified \code{tol} threshold.
}
\details{
Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.

If \code{hermitian = TRUE}, \code{A} is assumed to be Hermitian if complex or
symmetric if real, but this is not checked internally. Instead, just the lower
triangular part of the matrix is used in the computations.

If \code{tol} is not specified and \code{A} is a matrix of dimensions \verb{(m, n)},
the tolerance is set to be

\Sexpr[results=rd, stage=build]{torch:::math_to_rd("
tol = \\\\sigma_1 \\\\max(m, n) \\\\varepsilon
")}

where \teqn{\sigma_1} is the largest singular value
(or eigenvalue in absolute value when \code{hermitian = TRUE}), and
\teqn{\varepsilon} is the epsilon value for the dtype of \code{A} (see \code{\link[=torch_finfo]{torch_finfo()}}).

If \code{A} is a batch of matrices, \code{tol} is computed this way for every element of
the batch.
}
\examples{
if (torch_is_installed()) {
a <- torch_eye(10)
linalg_matrix_rank(a)

}
}
\seealso{
Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
