% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_hinge_embedding_loss}
\alias{nn_hinge_embedding_loss}
\title{Hinge embedding loss}
\usage{
nn_hinge_embedding_loss(margin = 1, reduction = "mean")
}
\arguments{
\item{margin}{(float, optional): Has a default value of \code{1}.}

\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed. Note: \code{size_average}
and \code{reduce} are in the process of being deprecated, and in the meantime,
specifying either of those two args will override \code{reduction}. Default: \code{'mean'}}
}
\description{
Measures the loss given an input tensor \eqn{x} and a labels tensor \eqn{y}
(containing 1 or -1).
}
\details{
This is usually used for measuring whether two inputs are similar or
dissimilar, e.g. using the L1 pairwise distance as \eqn{x}, and is typically
used for learning nonlinear embeddings or semi-supervised learning.
The loss function for \eqn{n}-th sample in the mini-batch is

\deqn{
  l_n = \begin{array}{ll}
x_n, & \mbox{if}\; y_n = 1,\\
\max \{0, \Delta - x_n\}, & \mbox{if}\; y_n = -1,
\end{array}
}

and the total loss functions is

\deqn{
  \ell(x, y) = \begin{array}{ll}
\mbox{mean}(L), & \mbox{if reduction} = \mbox{'mean';}\\
\mbox{sum}(L),  & \mbox{if reduction} = \mbox{'sum'.}
\end{array}
}

where \eqn{L = \{l_1,\dots,l_N\}^\top}.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(*)} where \eqn{*} means, any number of dimensions. The sum operation
operates over all the elements.
\item Target: \eqn{(*)}, same shape as the input
\item Output: scalar. If \code{reduction} is \code{'none'}, then same shape as the input
}
}

