% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_lcm}
\alias{torch_lcm}
\title{Lcm}
\usage{
torch_lcm(self, other)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{other}{(Tensor) the second input tensor}
}
\description{
Lcm
}
\note{
This defines \eqn{lcm(0, 0) = 0} and \eqn{lcm(0, a) = 0}.
}
\section{lcm(input, other, *, out=None) -> Tensor }{


Computes the element-wise least common multiple (LCM) of \code{input} and \code{other}.

Both \code{input} and \code{other} must have integer types.
}

\examples{
if (torch_is_installed()) {

if (torch::cuda_is_available()) {
a <- torch_tensor(c(5, 10, 15), dtype = torch_long(), device = "cuda")
b <- torch_tensor(c(3, 4, 5), dtype = torch_long(), device = "cuda")
torch_lcm(a, b)
c <- torch_tensor(c(3L), device = "cuda")
torch_lcm(a, c)
}
}
}
