% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-distance.R
\name{nn_pairwise_distance}
\alias{nn_pairwise_distance}
\title{Pairwise distance}
\usage{
nn_pairwise_distance(p = 2, eps = 1e-06, keepdim = FALSE)
}
\arguments{
\item{p}{(real): the norm degree. Default: 2}

\item{eps}{(float, optional): Small value to avoid division by zero.
Default: 1e-6}

\item{keepdim}{(bool, optional): Determines whether or not to keep the vector dimension.
Default: FALSE}
}
\description{
Computes the batchwise pairwise distance between vectors \eqn{v_1}, \eqn{v_2}
using the p-norm:
}
\details{
\deqn{
 \Vert x \Vert _p = \left( \sum_{i=1}^n  \vert x_i \vert ^ p \right) ^ {1/p}.
}
}
\section{Shape}{

\itemize{
\item Input1: \eqn{(N, D)} where \verb{D = vector dimension}
\item Input2: \eqn{(N, D)}, same shape as the Input1
\item Output: \eqn{(N)}. If \code{keepdim} is \code{TRUE}, then \eqn{(N, 1)}.
}
}

\examples{
if (torch_is_installed()) {
pdist <- nn_pairwise_distance(p=2)
input1 <- torch_randn(100, 128)
input2 <- torch_randn(100, 128)
output <- pdist(input1, input2)

}
}
