% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuda.R
\name{cuda_dump_memory_snapshot}
\alias{cuda_dump_memory_snapshot}
\title{Save CUDA Memory State Snapshot to File}
\usage{
cuda_dump_memory_snapshot(filepath)
}
\arguments{
\item{filepath}{Character; the path to the file where the snapshot will be saved.}
}
\value{
None; snapshot is saved directly to the file.
}
\description{
Calls \code{cuda_memory_snapshot()} and saves the resulting binary snapshot
to a specified file using \code{writeBin}. The resulting file can be visualized using the interactive
snapshot viewer available at \href{https://docs.pytorch.org/memory_viz}{pytorch.org/memory_viz}.
}
\examples{
if (torch_is_installed()) {
\dontrun{
cuda_dump_memory_snapshot("snapshot.bin")
}
}
}
