% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jit-ops.R
\docType{data}
\name{jit_ops}
\alias{jit_ops}
\title{Enable idiomatic access to JIT operators from R.}
\format{
An object of class \code{torch_ops} of length 0.
}
\usage{
jit_ops
}
\description{
Call JIT operators directly from R, keeping the familiar argument types and argument order.
Note, however, that:
\itemize{
\item all arguments are required (no defaults)
\item axis numbering (as well as position numbers overall) starts from 0
\item scalars have to be wrapped in \code{jit_scalar()}
}
}
\examples{
if (torch_is_installed()) {
t1 <- torch::torch_rand(4, 5)
t2 <- torch::torch_ones(5, 4)
# same as torch::torch_matmul(t1, t2)
jit_ops$aten$matmul(t1, t2)

# same as torch_split(torch::torch_arange(0, 3), 2, 1)
jit_ops$aten$split(torch::torch_arange(0, 3), torch::jit_scalar(2L), torch::jit_scalar(0L))

}
}
\keyword{datasets}
