% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-linear.R
\name{nn_linear}
\alias{nn_linear}
\title{Linear module}
\usage{
nn_linear(in_features, out_features, bias = TRUE)
}
\arguments{
\item{in_features}{size of each input sample}

\item{out_features}{size of each output sample}

\item{bias}{If set to \code{FALSE}, the layer will not learn an additive bias.
Default: \code{TRUE}}
}
\description{
Applies a linear transformation to the incoming data: \code{y = xA^T + b}
}
\section{Shape}{

\itemize{
\item Input: \verb{(N, *, H_in)} where \code{*} means any number of
additional dimensions and \code{H_in = in_features}.
\item Output: \verb{(N, *, H_out)} where all but the last dimension
are the same shape as the input and :math:\code{H_out = out_features}.
}
}

\section{Attributes}{

\itemize{
\item weight: the learnable weights of the module of shape
\verb{(out_features, in_features)}. The values are
initialized from \eqn{U(-\sqrt{k}, \sqrt{k})}s, where
\eqn{k = \frac{1}{\mbox{in\_features}}}
\item bias: the learnable bias of the module of shape \eqn{(\mbox{out\_features})}.
If \code{bias} is \code{TRUE}, the values are initialized from
\eqn{\mathcal{U}(-\sqrt{k}, \sqrt{k})} where
\eqn{k = \frac{1}{\mbox{in\_features}}}
}
}

\examples{
if (torch_is_installed()) {
m <- nn_linear(20, 30)
input <- torch_randn(128, 20)
output <- m(input)
print(output$size())
}
}
