% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-style.R
\name{grid-cell-style}
\alias{grid-cell-style}
\alias{grid_style_cell}
\alias{grid_style_cells}
\title{Set grid cell(s) style}
\usage{
grid_style_cell(
  grid,
  expr,
  column,
  background = NULL,
  color = NULL,
  fontWeight = NULL,
  ...,
  class = NULL,
  cssProperties = NULL
)

grid_style_cells(
  grid,
  fun,
  columns,
  background = NULL,
  color = NULL,
  ...,
  class = NULL,
  cssProperties = NULL
)
}
\arguments{
\item{grid}{A grid created with \code{\link[=datagrid]{datagrid()}}.}

\item{expr}{An expression giving position of row. Must return a logical vector.}

\item{column}{Name of column (variable name) where to apply style.}

\item{background}{Background color.}

\item{color}{Text color.}

\item{fontWeight}{Font weight, you can use \code{"bold"} for example.}

\item{...}{Other CSS properties.}

\item{class}{CSS class to apply to the row.}

\item{cssProperties}{Alternative to specify CSS properties with a named list.}

\item{fun}{Function to apply to \code{columns} to identify rows to style.}

\item{columns}{Columns names to use with \code{fun}.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Customize cell(s) appearance with CSS
according to an expression in the data used in the grid.
}
\examples{
library(toastui)

datagrid(mtcars) \%>\%
  grid_style_cell(
    mpg > 19,
    column = "mpg",
    background = "#F781BE",
    fontWeight = "bold"
  )


datagrid(mtcars) \%>\%
  grid_style_cell(
    vs == 0,
    column = "vs",
    background = "#E41A1C80",
    color = "#FFF"
  ) \%>\%
  grid_style_cell(
    vs == 1,
    column = "vs",
    background = "#377EB880"
  )


# Use rlang to use character
library(rlang)
my_var <- "disp"
datagrid(mtcars) \%>\%
  grid_style_cell(
    !!sym(my_var) > 180,
    column = "disp",
    background = "#F781BE"
  )




# Style multiple columns

cor_longley <- as.data.frame(cor(longley))
cor_longley$Var <- row.names(cor_longley)
vars <- c("GNP.deflator", "GNP",
          "Unemployed", "Armed.Forces",
          "Population", "Year", "Employed")
datagrid(cor_longley[, c("Var", vars)]) \%>\%
  grid_style_cells(
    fun = ~ . > 0.9,
    columns = vars,
    background = "#053061",
    color = "#FFF"
  ) \%>\%
  grid_style_cells(
    fun = ~ . > 0 & . <= 0.9,
    columns = vars,
    background = "#539dc8",
    color = "#FFF"
  ) \%>\%
  grid_style_cells(
    fun = ~ . < 0,
    columns = vars,
    background = "#b51f2e",
    color = "#FFF"
  )
}
