% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-proxy.R
\name{calendar-proxy-schedule}
\alias{calendar-proxy-schedule}
\alias{cal_proxy_add}
\alias{cal_proxy_delete}
\alias{cal_proxy_update}
\title{Create / Update / Delete schedule(s) with Proxy}
\usage{
cal_proxy_add(proxy, value)

cal_proxy_delete(proxy, value)

cal_proxy_update(proxy, value)
}
\arguments{
\item{proxy}{A \code{\link[=calendar_proxy]{calendar_proxy()}} \code{htmlwidget} object.}

\item{value}{A \code{list} with schedules data.}
}
\value{
A \code{calendar_proxy} object.
}
\description{
These functions allow to create new schedule(s), update existing
ones and delete schedule in a calendar within the server in a Shiny application.
}
\note{
Those functions are intended to be used with corresponding input value:
\itemize{
\item \verb{input$<outputId>_add}: triggered when a schedule is added on calendar via creation popup.
\item \verb{input$<outputId>_update}: triggered when an existing schedule is edited.
\item \verb{input$<outputId>_deleted}: triggered when a schedule is deleted.
}
}
\examples{
library(shiny)
library(toastui)

ui <- fluidPage(
  tags$h2("Add, Update and Delete schedule interactively"),

  tags$p(
    "Click on the calendar to create a new schedule",
    "then you will be able to edit or delete it."
  ),

  calendarOutput("my_calendar")
)

server <- function(input, output) {

  output$my_calendar <- renderCalendar({
    cal <- calendar(
      defaultDate = Sys.Date(),
      navigation = TRUE,
      isReadOnly = FALSE,
      useCreationPopup = TRUE
    )
  })

  observeEvent(input$my_calendar_add, {
    str(input$my_calendar_add)
    cal_proxy_add("my_calendar", input$my_calendar_add)
  })

  observeEvent(input$my_calendar_update, {
    str(input$my_calendar_update)
    cal_proxy_update("my_calendar", input$my_calendar_update)
  })

  observeEvent(input$my_calendar_delete, {
    str(input$my_calendar_delete)
    cal_proxy_delete("my_calendar", input$my_calendar_delete)
  })

}

if (interactive())
  shinyApp(ui = ui, server = server)
}
\seealso{
Other calendar proxy methods: 
\code{\link{cal_proxy_clear}()},
\code{\link{cal_proxy_options}()},
\code{\link{cal_proxy_toggle}()},
\code{\link{cal_proxy_view}()},
\code{\link{calendar-proxy-navigate}},
\code{\link{calendar_proxy}()}
}
\concept{calendar proxy methods}
