% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-utils.R
\name{cal_theme}
\alias{cal_theme}
\title{Calendar theme options}
\usage{
cal_theme(cal, ..., .list = NULL)
}
\arguments{
\item{cal}{A \code{\link[=calendar]{calendar()}} object.}

\item{...}{Named arguments to customize appearance with CSS. See online documentation for full list of options.}

\item{.list}{Alternative to \code{...} for using a list.}
}
\value{
A \code{calendar} htmlwidget object.
}
\description{
Full configuration for theme.
"common" prefix is for entire calendar. "common" properties can be overridden by "week", "month".
"week" prefix is for weekly and daily view.
"month" prefix is for monthly view.
}
\note{
Online JavaScript documentation: \url{https://nhn.github.io/tui.calendar/latest/themeConfig/}
}
\examples{
calendar(view = "month") \%>\%
  cal_theme(
    common.border = "2px solid #E5E9F0",
    month.dayname.borderLeft = "2px solid #E5E9F0",
    common.backgroundColor = "#2E3440",
    common.holiday.color = "#88C0D0",
    common.saturday.color = "#88C0D0",
    common.dayname.color = "#ECEFF4",
    common.today.color = "#333"
  )
}
