% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap.tna}
\alias{bootstrap.group_tna}
\title{Bootstrap Transition Networks from Sequence Data}
\usage{
bootstrap(x, ...)

\method{bootstrap}{tna}(x, iter = 1000, level = 0.05, threshold, ...)

\method{bootstrap}{group_tna}(x, ...)
}
\arguments{
\item{x}{A \code{tna} or a \code{group_tna} object created from sequence data.}

\item{...}{Ignored.}

\item{iter}{An \code{integer} specifying the number of bootstrap samples to
draw. Defaults to \code{1000}.}

\item{level}{A \code{numeric} value representing the significance level for
hypothesis testing and confidence intervals. Defaults to \code{0.05}.}

\item{threshold}{A \code{numeric} value to compare edge weights against.
The default is the 10th percentile of the edge weights.}
}
\value{
A \code{tna_bootstrap} object which is a \code{list} containing the
following elements:
\itemize{
\item \code{weights_orig}: The original edge weight \code{matrix}.
\item \code{weights_sig}: The \code{matrix} of significant transitions
(those with p-values below the significance level).
\item \code{weights_mean}: The mean weight \code{matrix} from the bootstrap samples.
\item \code{weights_sd}: The standard deviation \code{matrix} from the bootstrap samples.
\item \code{ci_lower}: The lower bound \code{matrix} of the confidence intervals for
the edge weights.
\item \code{ci_upper}: The upper bound \code{matrix} of the confidence intervals for
the edge weights.
\item \code{p_values}: The \code{matrix} of p-values for the edge weights.
\item \code{summary}: A \code{data.frame} summarizing the edges, their weights,
p-values, statistical significance and confidence intervals.
}

If \code{x} is a \code{group_tna} object, the output is a \code{group_tna_bootstrap}
object, which is a \code{list} of \code{tna_bootstrap} objects.
}
\description{
Perform bootstrapping on transition networks created from
sequence data stored in a \code{tna} object. Bootstrapped estimates
of edge weights are returned with confidence intervals and significance
testing.
}
\details{
The function first computes the original edge weights for the specified
cluster from the \code{tna} object. It then performs bootstrapping by resampling
the sequence data and recalculating the edge weights for each
bootstrap sample. The mean and standard deviation of the transitions are
computed, and confidence intervals are derived. The function also calculates
p-values for each edge and identifies significant edges based on
the specified significance level. A matrix of significant edges
(those with p-values below the significance level) is generated.
Additional statistics on removed edges (those not considered
significant) are provided.

All results, including the original transition matrix, bootstrapped
estimates, and summary statistics for removed edges, are returned in a
structured list.
}
\examples{
model <- tna(engagement)
# Small number of iterations for CRAN
bootstrap(model, iter = 10)

}
\seealso{
Evaluation and validation functions
\code{\link{permutation_test}()},
\code{\link{prune}()},
\code{\link{pruning_details}()}

Cluster-related functions
\code{\link{centralities}()},
\code{\link{cliques}()},
\code{\link{communities}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{group_model}()},
\code{\link{hist.group_tna}()},
\code{\link{mmm_stats}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.group_tna_centralities}()},
\code{\link{plot.group_tna_cliques}()},
\code{\link{plot.group_tna_communities}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{print.group_tna}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_centralities}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.group_tna_communities}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{rename_groups}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.group_tna_bootstrap}()}
}
\concept{clusters}
\concept{evaluation}
