% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_accum_multidim.R
\name{context_tensor}
\alias{context_tensor}
\title{Generate a multidimensional array for window and weight parameters}
\usage{
context_tensor(
  df,
  sender_cols = NULL,
  receiver_cols = NULL,
  mode_column = ATTR_NAMES$CONTEXT_ID,
  default_window = 1,
  default_weight = 1
)
}
\arguments{
\item{df}{A data.frame containing the data to extract unique values for senders, receivers, and modes.}

\item{sender_cols}{Character vector of column names in `df` to use as sender(s). Can be empty or NULL if not applicable.}

\item{receiver_cols}{Character vector of column names in `df` to use as receiver(s). Can be empty or NULL if not applicable.}

\item{mode_column}{Character string giving the column name in `df` to use as the mode (e.g., modality, channel). Can be empty or NULL if not applicable.}

\item{default_window}{Numeric value to use as the default window for all combinations (default: 1).}

\item{default_weight}{Numeric value to use as the default weight for all combinations (default: 1).}
}
\value{
A multidimensional array with dimensions [sender(s), receiver(s), mode(s), weight/window], where the last axis has two levels: "weight" and "window".
        The array is initialized with the default weight and window values, and has named dimensions for easy indexing.
}
\description{
This function constructs a multidimensional array representing all combinations of sender(s), receiver(s), and mode(s),
with an additional axis for weight and window parameters. The resulting array can be used to efficiently look up or modify
window and weight values for each unique combination in your data, which is useful for network accumulation and modeling.
}
\examples{
df <- data.frame(sender = c("A", "B"), receiver = c("X", "Y"), mode = c("chat", "resource"))
arr <- context_tensor(df, sender_cols = "sender", receiver_cols = "receiver", mode_column = "mode")
arr["A", "X", "chat", "weight"] # Access the weight for sender A, receiver X, mode chat

}
