% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tipa.R
\name{tipaPhaseRef}
\alias{tipaPhaseRef}
\title{Use phase reference points to estimate the phase shift induced by a stimulus
during a circadian time-course.}
\usage{
tipaPhaseRef(phaseRefTimes, stimOnset, stimDuration = 0, period = NULL)
}
\arguments{
\item{phaseRefTimes}{Vector of times of the chosen phase reference point.}

\item{stimOnset}{Time at which the stimulus started.}

\item{stimDuration}{Duration of the stimulus and any transients. Data between
\code{stimOnset} and \code{stimOnset + stimDuration} will be ignored.}

\item{period}{Optional list with elements "pre" and "post" corresponding to
the period of the oscillations prior to and subsequent to the stimulus. If
not supplied, the periods for pre- and post-stimulus are calculated as the
mean time between occurrences of the phase reference point within the
respective epoch. Using this argument is not recommended.}
}
\value{
A list.
\item{phaseShift}{Estimated phase shift in circadian hours. Negative values
indicate a delay, positive values an advance.}
\item{epochInfo}{\code{data.frame} containing estimated period for each epoch.}
}
\description{
Calculate the phase shift based on the times of a phase reference point
(e.g., onset of activity), accounting for possible period changes and for the
point in the circadian cycle at which the stimulus occurred. If the rhythms
of the measurement are approximately sinusoidal, it is recommended to instead
use \code{\link[=tipaCosinor]{tipaCosinor()}}.
}
\examples{
# Peak times of bioluminescence (in hours)
phaseRefTimes = c(-75.5, -51.5, -27.4, -3.8,
                  20.5, 42.4, 65.5, 88.0)
result = tipaPhaseRef(phaseRefTimes, stimOnset = 0)

# Data from multiple (simulated) experiments
getExtrFile = function() {
  system.file('extdata', 'phaseRefTimes.csv', package = 'tipa')}
getStimFile = function() {
  system.file('extdata', 'stimOnsets.csv', package = 'tipa')}

extrDf = read.csv(getExtrFile(), stringsAsFactors = FALSE)
stimDf = read.csv(getStimFile(), stringsAsFactors = FALSE)

resultList = lapply(stimDf$expId, function(ii) {
  phaseRefTimes = extrDf$phaseRefTime[extrDf$expId == ii]
  stimOnset = stimDf$stimOnset[stimDf$expId == ii]
  tipaPhaseRef(phaseRefTimes, stimOnset)})

phaseShifts = sapply(resultList, function(r) r$phaseShift)

}
\seealso{
\code{\link[=tipaCosinor]{tipaCosinor()}}
}
