% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_area.R, R/type_ribbon.R
\name{type_area}
\alias{type_area}
\alias{type_ribbon}
\title{Ribbon and area plot types}
\usage{
type_area(alpha = NULL)

type_ribbon(alpha = NULL)
}
\arguments{
\item{alpha}{numeric value between 0 and 1 specifying the opacity of ribbon shading
If no \code{alpha} value is provided, then will default to \code{tpar("ribbon.alpha")}
(i.e., probably \code{0.2} unless this has been overridden by the user in their global
settings.)}
}
\description{
Type constructor functions for producing polygon ribbons, which
define a \code{y} interval (usually spanning from \code{ymin} to \code{ymax}) for each
\code{x} value. Area plots are a special case of ribbon plot where \code{ymin} is
set to 0 and \code{ymax} is set to \code{y}.
}
\examples{
x = 1:100/10
y = sin(x)

#
## Ribbon plots

# "ribbon" convenience string
tinyplot(x = x, ymin = y-1, ymax = y+1, type = "ribbon")
# Same result with type_ribbon()
tinyplot(x = x, ymin = y-1, ymax = y+1, type = type_ribbon())

# y will be added as a line if it is specified
tinyplot(x = x, y = y, ymin = y-1, ymax = y+1, type = "ribbon")

#
## Area plots
  
# "area" type convenience string
tinyplot(x, y, type = "area")

# Same result with type_area()
tinyplot(x, y, type = type_area())

# Area plots are often used for time series charts
tinyplot(AirPassengers, type = "area")
}
