% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics-tk_seasonal_diagnostics.R
\name{tk_seasonal_diagnostics}
\alias{tk_seasonal_diagnostics}
\title{Group-wise Seasonality Data Preparation}
\usage{
tk_seasonal_diagnostics(.data, .date_var, .value, .feature_set = "auto")
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} with a time-based column}

\item{.date_var}{A column containing either date or date-time values}

\item{.value}{A column containing numeric values}

\item{.feature_set}{One or multiple selections to analyze for seasonality. Choices include:
\itemize{
\item "auto" - Automatically selects features based on the time stamps and length of the series.
\item "second" - Good for analyzing seasonality by second of each minute.
\item "minute" - Good for analyzing seasonality by minute of the hour
\item "hour" - Good for analyzing seasonality by hour of the day
\item "wday.lbl" - Labeled weekdays. Good for analyzing seasonality by day of the week.
\item "week" - Good for analyzing seasonality by week of the year.
\item "month.lbl" - Labeled months. Good for analyzing seasonality by month of the year.
\item "quarter" - Good for analyzing seasonality by quarter of the year
\item "year" - Good for analyzing seasonality over multiple years.
}}
}
\value{
A \code{tibble} or \code{data.frame} with seasonal features
}
\description{
\code{tk_seasonal_diagnostics()} is the preprocessor for \code{plot_seasonal_diagnostics()}.
It helps by automating feature collection for time series seasonality analysis.
}
\details{
\strong{Automatic Feature Selection}

Internal calculations are performed to detect a sub-range of features to include
useing the following logic:
\itemize{
\item The \emph{minimum} feature is selected based on the median difference between consecutive
timestamps
\item The \emph{maximum} feature is selected based on having 2 full periods.
}

Example: Hourly timestamp data that lasts more than 2 weeks will have the following features:
"hour", "wday.lbl", and "week".

\strong{Scalable with Grouped Data Frames}

This function respects grouped \code{data.frame} and \code{tibbles} that were made with \code{dplyr::group_by()}.

For grouped data, the automatic feature selection returned is a collection of all
features within the sub-groups. This means extra features are returned even though
they may be meaningless for some of the groups.

\strong{Transformations}

The \code{.value} parameter respects transformations (e.g. \code{.value = log(sales)}).
}
\examples{
\donttest{
library(dplyr)
library(timetk)

# ---- GROUPED EXAMPLES ----

# Hourly Data
m4_hourly \%>\%
    group_by(id) \%>\%
    tk_seasonal_diagnostics(date, value)

# Monthly Data
m4_monthly \%>\%
    group_by(id) \%>\%
    tk_seasonal_diagnostics(date, value)

# ---- TRANSFORMATION ----

m4_weekly \%>\%
    group_by(id) \%>\%
    tk_seasonal_diagnostics(date, log(value))

# ---- CUSTOM FEATURE SELECTION ----

m4_hourly \%>\%
    group_by(id) \%>\%
    tk_seasonal_diagnostics(date, value, .feature_set = c("hour", "week"))

}

}
