% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plot_timeline}
\alias{plot_timeline}
\title{Plotting function (standard style)}
\usage{
plot_timeline(timeline_df, data_cols = NULL, start_time = NULL,
  end_time = NULL, ylimits = NULL, scale_vals = NULL, titles = NULL,
  ylabels = NULL, save_path = NULL, add_legend = TRUE,
  plot_size_ratios = NULL, overlap_plots_names = NULL,
  color_mapping = list(), order_plots = NULL, plot_output = T,
  numeric_plot_type = "line")
}
\arguments{
\item{timeline_df}{Dataframe}

\item{data_cols}{A vector showing the columns to subset for plotting}

\item{start_time}{is left end point of the plot
e.g: start_time="2014-01-30 09:53:02.792663 UTC" or start_time=1391075599}

\item{end_time}{is right end point of the plot}

\item{ylimits}{A named vector to determine the limits on the y-axis for Sample plots
e.g: ylimits=list(a=c(0,100),d=c(-100,50)). The names must be present in the data frame}

\item{scale_vals}{A named vector to scale numeric data
e.g: scale_vals = c(a=10), matching data will be multiplied by 10}

\item{titles}{A named vector to give titles to the plot. For state and numeric plots, the names should be the same
as in the data frame. For overlapping plots, it should be the same as the name given in the overlap_plots_names.
e.g: titles = c(ab="first plot",cd="second plot")}

\item{ylabels}{change the labels on y-axis of plots
e.g: ylabel=c(ab="value",bcd="tmeperature")}

\item{save_path}{if a file_path is specified, then the image will be saved to that location.}

\item{add_legend}{TRUE (default) if legend is needed for the plots}

\item{plot_size_ratios}{proportion of event plot size to the sample plot size}

\item{overlap_plots_names}{specify the data items to be overlapped. Plots of the same type can only be overlapped for now.
This argument can be used to specify the order of plots.
e.g.: overlap_plots="list(overlap_plot1 = c(state1,numeric1), overlap_plot2 = c(state1,numeric2)"}

\item{color_mapping}{A named list of named vectors. The names of the list are the names of the state columns in 
the data frame. Each named vector for a state should have color mapping for all the states in the column.}

\item{order_plots}{A vector containing the name of the plots to be plotted. The plots in the final output are 
arranged according to the order of the names in this vector.}

\item{plot_output}{Logical argument to specify if the output is required to be plotted or not. TRUE(default)}

\item{numeric_plot_type}{The plot type for numeric variables. It can be either of the type `line`,`step` or `point`. 
By default the type is `line`.}
}
\value{
A grob of all the plots
}
\description{
Plots time series data of State type (factors) as stripe charts, Numeric data type as step charts and an overlapping
combination of a plot of State type and Numeric type .
}

