% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{get_route_geometry}
\alias{get_route_geometry}
\title{Get all trip shapes for a given route and service.}
\usage{
get_route_geometry(gtfs_sf_obj, route_ids = NULL, service_ids = NULL)
}
\arguments{
\item{gtfs_sf_obj}{tidytransit gtfs object with sf data frames}

\item{route_ids}{routes to extract}

\item{service_ids}{service_ids to extract}
}
\value{
an sf dataframe for gtfs routes with a row/linestring for each trip
}
\description{
Get all trip shapes for a given route and service.
}
\examples{
data(gtfs_duke)
gtfs_duke_sf <- gtfs_as_sf(gtfs_duke)
routes_sf <- get_route_geometry(gtfs_duke_sf)
plot(routes_sf[c(1,1350),])
}
