% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringr-like.R
\name{as_formatted_p_value}
\alias{as_formatted_p_value}
\title{Formatting p values}
\usage{
as_formatted_p_value(
  x,
  decimal_places = 3,
  prefix = "p",
  less_than_cutoff = 0.001,
  remove_trailing_zeroes = T,
  alpha = 0.05,
  ns_replacement = NULL
)
}
\arguments{
\item{x}{Numeric vector}

\item{decimal_places}{Decimal places to display}

\item{prefix}{Prefix to prepend (default "p=")}

\item{less_than_cutoff}{Cut-off for small p values. Values smaller than this will be displayed like "p<..."}

\item{remove_trailing_zeroes}{If the required decimal places are less than decimal places,
should resulting trailing zeros be removed?}

\item{alpha}{Cut-off for assuming significance, usually 0.05}

\item{ns_replacement}{If p value is not significant (is > alpha), it will be replace by this string (e.g. "n.s.")
If NULL (default), no replacement is performed.

Vectorised (in parallel) over x, prefix, less_than_cutoff, alpha and ns_replacement.}
}
\value{
Character vector
}
\description{
Vectorised conversion
}
\examples{
as_formatted_p_value(0.02) # "p=0.02"
as_formatted_p_value(0.00056) # "p<0.001"
}
