% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate.R
\name{separate.}
\alias{separate.}
\alias{dt_separate}
\title{Separate a character column into multiple columns}
\usage{
separate.(.df, col, into, sep = "[^[:alnum:]]+", remove = TRUE, ...)

dt_separate(.df, col, into, sep = "[^[:alnum:]]+", remove = TRUE, ...)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{col}{The column to split into multiple columns}

\item{into}{New column names to split into. A character vector.}

\item{sep}{Separator to split on. Can be specified or detected automatically}

\item{remove}{If TRUE, remove the input column from the output data.table}

\item{...}{Further argument to pass to data.table::tstrsplit}
}
\description{
Separates a single column into multiple columns using a user supplied separator or regex.

If a separator is not supplied one will be automatically detected.

Note: Using automatic detection or regex will be slower than simple separators such as "," or ".".
}
\examples{
test_df <- data.table(x = c("a", "a.b", "a.b", NA))

# "sep" can be automatically detected (slower)
test_df \%>\%
  separate.(x, into = c("c1", "c2"))

# Faster if "sep" is provided
test_df \%>\%
  separate.(x, into = c("c1", "c2"), sep = ".")
}
