% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_fisher.R
\name{report_fisher}
\alias{report_fisher}
\title{Report function for Fisher's Exact Tests for Count Data}
\usage{
report_fisher(identifier, results = getOption("tidystats_list"))
}
\arguments{
\item{identifier}{A character string identifying the model.}

\item{results}{A tidystats list.}
}
\description{
Function to report Fisher's Exact Tests for Count Data in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Set the default tidystats list in options()
options(tidystats_list = results)

# Report results
report(identifier = "fisher_test")
report(identifier = "fisher_test_hybrid")
report(identifier = "fisher_test_simulated_p")

}
