% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_initial_split.R
\name{spatial_initial_split}
\alias{spatial_initial_split}
\title{Simple Training/Test Set Splitting for spatial data}
\usage{
spatial_initial_split(data, prop, strategy, ...)
}
\arguments{
\item{data}{A dataset (data.frame or tibble)}

\item{prop}{The proportion of data to be retained for modelling/analysis.}

\item{strategy}{A sampling strategy from \code{spatialsample}}

\item{...}{parameters to be passed to the \code{strategy}}
}
\value{
An \code{rsplit} object that can be used with the \link[rsample:initial_split]{rsample::training} and
\link[rsample:initial_split]{rsample::testing} functions to extract the data in each split.
}
\description{
\code{spatial_initial_split} creates a single binary split of the data into a
training set and testing set. All strategies from the package \code{spatialsample}
are available; a random split from that strategy will be used to generate the
initial split.
}
\examples{
set.seed(123)
block_initial <- spatial_initial_split(boston_canopy,
  prop = 1 / 5, spatial_block_cv
)
testing(block_initial)
training(block_initial)
}
