% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy-methods.R
\name{tidy.tidylda}
\alias{tidy.tidylda}
\alias{tidy.matrix}
\title{Tidy a matrix from a \code{tidylda} topic model}
\usage{
\method{tidy}{tidylda}(x, matrix, log = FALSE, ...)

\method{tidy}{matrix}(x, matrix, log = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{tidylda} or an individual \code{beta}, 
\code{theta}, or \code{lambda} matrix.}

\item{matrix}{the matrix to tidy; one of \code{'beta'}, \code{'theta'}, or
\code{'lambda'}}

\item{log}{do you want to have the result on a log scale? Defaults to \code{FALSE}}

\item{...}{other arguments passed to methods,currently not used}
}
\value{
Returns a \code{\link[tibble]{tibble}}.

  If \code{matrix = "beta"} then the result is a table of one row per topic
  and token with the following columns: \code{topic}, \code{token}, \code{beta}

  If \code{matrix = "theta"} then the result is a table of one row per document
  and topic with the following columns: \code{document}, \code{topic}, \code{theta}

  If \code{matrix = "lambda"} then the result is a table of one row per topic
  and token with the following columns: \code{topic}, \code{token}, \code{lambda}
}
\description{
Tidy the result of a \code{tidylda} topic model
}
\section{Functions}{
\itemize{
\item \code{tidy(matrix)}: Tidy an individual matrix.
Useful for predictions and called from tidy.tidylda

}}
\note{
If \code{log = TRUE} then "log_" will be appended to the name of the third
  column of the resulting table. e.g "\code{beta}" becomes "\code{log_beta}".
}
\examples{
\donttest{
dtm <- nih_sample_dtm

lda <- tidylda(data = dtm, k = 10, iterations = 100, burnin = 75)

tidy_beta <- tidy(lda, matrix = "beta")

tidy_theta <- tidy(lda, matrix = "theta")

tidy_lambda <- tidy(lda, matrix = "lambda")
}
}
