% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-graph.R
\name{get_graph}
\alias{get_graph}
\title{Get the CWL workflow graph}
\usage{
get_graph(inputs, outputs, steps)
}
\arguments{
\item{inputs}{Parsed inputs}

\item{outputs}{Parsed outputs}

\item{steps}{Parsed steps}
}
\value{
List of two data frames containing node and edge information
}
\description{
Get the CWL workflow graph as a list of two data frames:
a data frame of nodes and a data frame of edges.
}
\examples{
# sbg:draft2
flow <- system.file("cwl/sbg/workflow/gatk4-wgs.json", package = "tidycwl") \%>\% read_cwl_json()
get_graph(
  flow \%>\% parse_inputs(),
  flow \%>\% parse_outputs(),
  flow \%>\% parse_steps()
) \%>\% str()

# v1.0
flow <- system.file("cwl/sbg/workflow/rnaseq-salmon.json", package = "tidycwl") \%>\% read_cwl_json()
get_graph(
  flow \%>\% parse_inputs(),
  flow \%>\% parse_outputs(),
  flow \%>\% parse_steps()
) \%>\% str()
}
