% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-param.R
\name{get_inputs_id}
\alias{get_inputs_id}
\title{Get ID for inputs}
\usage{
get_inputs_id(inputs)
}
\arguments{
\item{inputs}{Parsed inputs}
}
\value{
Vector of input IDs
}
\description{
Get ID for inputs
}
\examples{
# inputs represented by a dictionary
system.file("cwl/sbg/workflow/rnaseq-salmon.json", package = "tidycwl") \%>\%
  read_cwl_json() \%>\%
  parse_inputs() \%>\%
  get_inputs_id()

# inputs represented by a list
system.file("cwl/sbg/workflow/rnaseq-salmon.cwl", package = "tidycwl") \%>\%
  read_cwl_yaml() \%>\%
  parse_inputs() \%>\%
  get_inputs_id()
}
