% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom_methods.R
\name{broom_methods_cuminc}
\alias{broom_methods_cuminc}
\alias{tidy.tidycuminc}
\alias{glance.tidycuminc}
\title{Broom methods for tidy cuminc objects}
\usage{
\method{tidy}{tidycuminc}(x, conf.int = FALSE, conf.level = 0.95, times = NULL, ...)

\method{glance}{tidycuminc}(x, ...)
}
\arguments{
\item{x}{object of class 'tidycuminc'}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{times}{Numeric vector of times to obtain risk estimates at}

\item{...}{not used}
}
\value{
a tibble
}
\description{
Broom methods for tidy cuminc objects
}
\section{\code{tidy()} confidence intervals}{


The confidence intervals in \code{tidy()} use the recommended method in
\emph{Competing Risks: A Practical Perspective} by Melania Pintilie.

\verb{  x^exp(-z * se / (x * log(x))), x^exp(z * se / (x * log(x)))}
}

\examples{
cuminc <- cuminc(Surv(ttdeath, death_cr) ~ trt, trial)

tidy(cuminc)

glance(cuminc)
}
\seealso{
Other cuminc() functions: 
\code{\link{autoplot.tidycuminc}()},
\code{\link{cuminc}()}
}
\concept{cuminc tidiers}
\concept{cuminc() functions}
\concept{tidycuminc tidiers}
