% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_unnest.R
\name{time_unnest}
\alias{time_unnest}
\title{Unnest a \code{tibble} containing a list-column of \code{tbl_time} objects}
\usage{
time_unnest(data, ...)
}
\arguments{
\item{data}{A \code{tibble} containing a list-column of \code{tbl_time} objects.}

\item{...}{Passed on to \code{\link[tidyr:unnest]{tidyr::unnest()}}.}
}
\description{
When a \code{tbl_time} object is nested by \code{\link[tidyr:nest]{tidyr::nest()}}, the outer object is
often a \code{tibble}, and the nested list-column contains \code{tbl_time} objects.
This allows you to unnest that list-column and retain time information.
}
\examples{

data(FANG)
FANG <- as_tbl_time(FANG, date) \%>\%
   dplyr::group_by(symbol)

FANG_nested <- tidyr::nest(FANG)

# FANG_nested is not a `tbl_time` anymore
class(FANG_nested)

# The list column contains the `tbl_time` objects because they have the
# index.
class(FANG_nested$data[[1]])

# Unnest and keep time information
time_unnest(FANG_nested)

}
