// Generated by rstantools.  Do not edit by hand.

/*
    thurstonianIRT is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    thurstonianIRT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with thurstonianIRT.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_thurstonian_irt_model_newdata_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_thurstonian_irt_model_newdata");
    reader.add_event(1, 1, "include", "/include/functions-cumulative_Phi_lpmf.stan");
    reader.add_event(1, 0, "start", "/include/functions-cumulative_Phi_lpmf.stan");
    reader.add_event(22, 21, "end", "/include/functions-cumulative_Phi_lpmf.stan");
    reader.add_event(22, 2, "restart", "model_thurstonian_irt_model_newdata");
    reader.add_event(24, 4, "include", "/include/data-shared.stan");
    reader.add_event(24, 0, "start", "/include/data-shared.stan");
    reader.add_event(61, 37, "end", "/include/data-shared.stan");
    reader.add_event(61, 5, "restart", "model_thurstonian_irt_model_newdata");
    reader.add_event(86, 30, "include", "/include/model-likelihood.stan");
    reader.add_event(86, 0, "start", "/include/model-likelihood.stan");
    reader.add_event(135, 49, "end", "/include/model-likelihood.stan");
    reader.add_event(135, 31, "restart", "model_thurstonian_irt_model_newdata");
    reader.add_event(141, 35, "end", "model_thurstonian_irt_model_newdata");
    return reader;
}
template <bool propto, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T1__, T2__>::type
cumulative_Phi_lpmf(const int& y,
                        const T1__& mu,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& thres, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 12;
        int ncat(0);
        (void) ncat;  // dummy to suppress unused var warning
        stan::math::fill(ncat, std::numeric_limits<int>::min());
        stan::math::assign(ncat,(num_elements(thres) + 1));
        current_statement_begin__ = 13;
        local_scalar_t__ p(DUMMY_VAR__);
        (void) p;  // dummy to suppress unused var warning
        stan::math::initialize(p, DUMMY_VAR__);
        stan::math::fill(p, DUMMY_VAR__);
        current_statement_begin__ = 14;
        if (as_bool(logical_eq(y, 0))) {
            current_statement_begin__ = 15;
            stan::math::assign(p, Phi((get_base1(thres, 1, "thres", 1) - mu)));
        } else if (as_bool(logical_eq(y, (ncat - 1)))) {
            current_statement_begin__ = 17;
            stan::math::assign(p, (1 - Phi((get_base1(thres, (ncat - 1), "thres", 1) - mu))));
        } else {
            current_statement_begin__ = 19;
            stan::math::assign(p, (Phi((get_base1(thres, (y + 1), "thres", 1) - mu)) - Phi((get_base1(thres, y, "thres", 1) - mu))));
        }
        current_statement_begin__ = 21;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::log(p));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T1__, typename T2__>
typename boost::math::tools::promote_args<T1__, T2__>::type
cumulative_Phi_lpmf(const int& y,
                        const T1__& mu,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& thres, std::ostream* pstream__) {
    return cumulative_Phi_lpmf<false>(y,mu,thres, pstream__);
}
struct cumulative_Phi_lpmf_functor__ {
    template <bool propto, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T1__, T2__>::type
    operator()(const int& y,
                        const T1__& mu,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& thres, std::ostream* pstream__) const {
        return cumulative_Phi_lpmf(y, mu, thres, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_thurstonian_irt_model_newdata
  : public stan::model::model_base_crtp<model_thurstonian_irt_model_newdata> {
private:
        int family;
        int N;
        std::vector<int> Yint;
        std::vector<double> Yreal;
        int N_item;
        int N_itemC;
        int N_person;
        int N_trait;
        int N_item_fix;
        int N_item_est;
        std::vector<int> J_item1;
        std::vector<int> J_item2;
        std::vector<int> J_itemC;
        std::vector<int> J_person;
        std::vector<int> J_trait1;
        std::vector<int> J_trait2;
        std::vector<int> J_item_fix;
        std::vector<int> J_item_est;
        int N_item_pos;
        int N_item_neg;
        std::vector<int> J_item_pos;
        std::vector<int> J_item_neg;
        int N_item_equal;
        std::vector<int> J_item_equal;
        std::vector<int> J_item_orig;
        int ncat;
        vector_d lambda;
        vector_d psi;
        vector_d r;
        vector_d gamma;
        std::vector<vector_d> gamma_ord;
        vector_d disp;
        matrix_d L_trait;
public:
    model_thurstonian_irt_model_newdata(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_thurstonian_irt_model_newdata(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_thurstonian_irt_model_newdata_namespace::model_thurstonian_irt_model_newdata";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 26;
            context__.validate_dims("data initialization", "family", "int", context__.to_vec());
            family = int(0);
            vals_i__ = context__.vals_i("family");
            pos__ = 0;
            family = vals_i__[pos__++];
            check_greater_or_equal(function__, "family", family, 1);
            check_less_or_equal(function__, "family", family, 4);
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 33;
            validate_non_negative_index("Yint", "((primitive_value(logical_eq(family, 1)) || primitive_value(logical_eq(family, 2))) ? N : 0 )", ((primitive_value(logical_eq(family, 1)) || primitive_value(logical_eq(family, 2))) ? N : 0 ));
            context__.validate_dims("data initialization", "Yint", "int", context__.to_vec(((primitive_value(logical_eq(family, 1)) || primitive_value(logical_eq(family, 2))) ? N : 0 )));
            Yint = std::vector<int>(((primitive_value(logical_eq(family, 1)) || primitive_value(logical_eq(family, 2))) ? N : 0 ), int(0));
            vals_i__ = context__.vals_i("Yint");
            pos__ = 0;
            size_t Yint_k_0_max__ = ((primitive_value(logical_eq(family, 1)) || primitive_value(logical_eq(family, 2))) ? N : 0 );
            for (size_t k_0__ = 0; k_0__ < Yint_k_0_max__; ++k_0__) {
                Yint[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 34;
            validate_non_negative_index("Yreal", "((primitive_value(logical_eq(family, 3)) || primitive_value(logical_eq(family, 4))) ? N : 0 )", ((primitive_value(logical_eq(family, 3)) || primitive_value(logical_eq(family, 4))) ? N : 0 ));
            context__.validate_dims("data initialization", "Yreal", "double", context__.to_vec(((primitive_value(logical_eq(family, 3)) || primitive_value(logical_eq(family, 4))) ? N : 0 )));
            Yreal = std::vector<double>(((primitive_value(logical_eq(family, 3)) || primitive_value(logical_eq(family, 4))) ? N : 0 ), double(0));
            vals_r__ = context__.vals_r("Yreal");
            pos__ = 0;
            size_t Yreal_k_0_max__ = ((primitive_value(logical_eq(family, 3)) || primitive_value(logical_eq(family, 4))) ? N : 0 );
            for (size_t k_0__ = 0; k_0__ < Yreal_k_0_max__; ++k_0__) {
                Yreal[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 35;
            context__.validate_dims("data initialization", "N_item", "int", context__.to_vec());
            N_item = int(0);
            vals_i__ = context__.vals_i("N_item");
            pos__ = 0;
            N_item = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_item", N_item, 1);
            current_statement_begin__ = 36;
            context__.validate_dims("data initialization", "N_itemC", "int", context__.to_vec());
            N_itemC = int(0);
            vals_i__ = context__.vals_i("N_itemC");
            pos__ = 0;
            N_itemC = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_itemC", N_itemC, 1);
            current_statement_begin__ = 37;
            context__.validate_dims("data initialization", "N_person", "int", context__.to_vec());
            N_person = int(0);
            vals_i__ = context__.vals_i("N_person");
            pos__ = 0;
            N_person = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_person", N_person, 1);
            current_statement_begin__ = 38;
            context__.validate_dims("data initialization", "N_trait", "int", context__.to_vec());
            N_trait = int(0);
            vals_i__ = context__.vals_i("N_trait");
            pos__ = 0;
            N_trait = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_trait", N_trait, 1);
            current_statement_begin__ = 39;
            context__.validate_dims("data initialization", "N_item_fix", "int", context__.to_vec());
            N_item_fix = int(0);
            vals_i__ = context__.vals_i("N_item_fix");
            pos__ = 0;
            N_item_fix = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_item_fix", N_item_fix, 0);
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "N_item_est", "int", context__.to_vec());
            N_item_est = int(0);
            vals_i__ = context__.vals_i("N_item_est");
            pos__ = 0;
            N_item_est = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_item_est", N_item_est, 0);
            current_statement_begin__ = 42;
            validate_non_negative_index("J_item1", "N", N);
            context__.validate_dims("data initialization", "J_item1", "int", context__.to_vec(N));
            J_item1 = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("J_item1");
            pos__ = 0;
            size_t J_item1_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < J_item1_k_0_max__; ++k_0__) {
                J_item1[k_0__] = vals_i__[pos__++];
            }
            size_t J_item1_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < J_item1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_item1[i_0__]", J_item1[i_0__], 1);
            }
            current_statement_begin__ = 43;
            validate_non_negative_index("J_item2", "N", N);
            context__.validate_dims("data initialization", "J_item2", "int", context__.to_vec(N));
            J_item2 = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("J_item2");
            pos__ = 0;
            size_t J_item2_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < J_item2_k_0_max__; ++k_0__) {
                J_item2[k_0__] = vals_i__[pos__++];
            }
            size_t J_item2_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < J_item2_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_item2[i_0__]", J_item2[i_0__], 1);
            }
            current_statement_begin__ = 44;
            validate_non_negative_index("J_itemC", "N", N);
            context__.validate_dims("data initialization", "J_itemC", "int", context__.to_vec(N));
            J_itemC = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("J_itemC");
            pos__ = 0;
            size_t J_itemC_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < J_itemC_k_0_max__; ++k_0__) {
                J_itemC[k_0__] = vals_i__[pos__++];
            }
            size_t J_itemC_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < J_itemC_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_itemC[i_0__]", J_itemC[i_0__], 1);
            }
            current_statement_begin__ = 45;
            validate_non_negative_index("J_person", "N", N);
            context__.validate_dims("data initialization", "J_person", "int", context__.to_vec(N));
            J_person = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("J_person");
            pos__ = 0;
            size_t J_person_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < J_person_k_0_max__; ++k_0__) {
                J_person[k_0__] = vals_i__[pos__++];
            }
            size_t J_person_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < J_person_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_person[i_0__]", J_person[i_0__], 1);
            }
            current_statement_begin__ = 46;
            validate_non_negative_index("J_trait1", "N", N);
            context__.validate_dims("data initialization", "J_trait1", "int", context__.to_vec(N));
            J_trait1 = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("J_trait1");
            pos__ = 0;
            size_t J_trait1_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < J_trait1_k_0_max__; ++k_0__) {
                J_trait1[k_0__] = vals_i__[pos__++];
            }
            size_t J_trait1_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < J_trait1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_trait1[i_0__]", J_trait1[i_0__], 1);
            }
            current_statement_begin__ = 47;
            validate_non_negative_index("J_trait2", "N", N);
            context__.validate_dims("data initialization", "J_trait2", "int", context__.to_vec(N));
            J_trait2 = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("J_trait2");
            pos__ = 0;
            size_t J_trait2_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < J_trait2_k_0_max__; ++k_0__) {
                J_trait2[k_0__] = vals_i__[pos__++];
            }
            size_t J_trait2_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < J_trait2_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_trait2[i_0__]", J_trait2[i_0__], 1);
            }
            current_statement_begin__ = 48;
            validate_non_negative_index("J_item_fix", "N_item_fix", N_item_fix);
            context__.validate_dims("data initialization", "J_item_fix", "int", context__.to_vec(N_item_fix));
            J_item_fix = std::vector<int>(N_item_fix, int(0));
            vals_i__ = context__.vals_i("J_item_fix");
            pos__ = 0;
            size_t J_item_fix_k_0_max__ = N_item_fix;
            for (size_t k_0__ = 0; k_0__ < J_item_fix_k_0_max__; ++k_0__) {
                J_item_fix[k_0__] = vals_i__[pos__++];
            }
            size_t J_item_fix_i_0_max__ = N_item_fix;
            for (size_t i_0__ = 0; i_0__ < J_item_fix_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_item_fix[i_0__]", J_item_fix[i_0__], 1);
            }
            current_statement_begin__ = 49;
            validate_non_negative_index("J_item_est", "N_item_est", N_item_est);
            context__.validate_dims("data initialization", "J_item_est", "int", context__.to_vec(N_item_est));
            J_item_est = std::vector<int>(N_item_est, int(0));
            vals_i__ = context__.vals_i("J_item_est");
            pos__ = 0;
            size_t J_item_est_k_0_max__ = N_item_est;
            for (size_t k_0__ = 0; k_0__ < J_item_est_k_0_max__; ++k_0__) {
                J_item_est[k_0__] = vals_i__[pos__++];
            }
            size_t J_item_est_i_0_max__ = N_item_est;
            for (size_t i_0__ = 0; i_0__ < J_item_est_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_item_est[i_0__]", J_item_est[i_0__], 1);
            }
            current_statement_begin__ = 51;
            context__.validate_dims("data initialization", "N_item_pos", "int", context__.to_vec());
            N_item_pos = int(0);
            vals_i__ = context__.vals_i("N_item_pos");
            pos__ = 0;
            N_item_pos = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_item_pos", N_item_pos, 0);
            current_statement_begin__ = 52;
            context__.validate_dims("data initialization", "N_item_neg", "int", context__.to_vec());
            N_item_neg = int(0);
            vals_i__ = context__.vals_i("N_item_neg");
            pos__ = 0;
            N_item_neg = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_item_neg", N_item_neg, 0);
            current_statement_begin__ = 53;
            validate_non_negative_index("J_item_pos", "N_item_pos", N_item_pos);
            context__.validate_dims("data initialization", "J_item_pos", "int", context__.to_vec(N_item_pos));
            J_item_pos = std::vector<int>(N_item_pos, int(0));
            vals_i__ = context__.vals_i("J_item_pos");
            pos__ = 0;
            size_t J_item_pos_k_0_max__ = N_item_pos;
            for (size_t k_0__ = 0; k_0__ < J_item_pos_k_0_max__; ++k_0__) {
                J_item_pos[k_0__] = vals_i__[pos__++];
            }
            size_t J_item_pos_i_0_max__ = N_item_pos;
            for (size_t i_0__ = 0; i_0__ < J_item_pos_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_item_pos[i_0__]", J_item_pos[i_0__], 1);
            }
            current_statement_begin__ = 54;
            validate_non_negative_index("J_item_neg", "N_item_neg", N_item_neg);
            context__.validate_dims("data initialization", "J_item_neg", "int", context__.to_vec(N_item_neg));
            J_item_neg = std::vector<int>(N_item_neg, int(0));
            vals_i__ = context__.vals_i("J_item_neg");
            pos__ = 0;
            size_t J_item_neg_k_0_max__ = N_item_neg;
            for (size_t k_0__ = 0; k_0__ < J_item_neg_k_0_max__; ++k_0__) {
                J_item_neg[k_0__] = vals_i__[pos__++];
            }
            size_t J_item_neg_i_0_max__ = N_item_neg;
            for (size_t i_0__ = 0; i_0__ < J_item_neg_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_item_neg[i_0__]", J_item_neg[i_0__], 1);
            }
            current_statement_begin__ = 56;
            context__.validate_dims("data initialization", "N_item_equal", "int", context__.to_vec());
            N_item_equal = int(0);
            vals_i__ = context__.vals_i("N_item_equal");
            pos__ = 0;
            N_item_equal = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_item_equal", N_item_equal, 0);
            current_statement_begin__ = 57;
            validate_non_negative_index("J_item_equal", "N_item_equal", N_item_equal);
            context__.validate_dims("data initialization", "J_item_equal", "int", context__.to_vec(N_item_equal));
            J_item_equal = std::vector<int>(N_item_equal, int(0));
            vals_i__ = context__.vals_i("J_item_equal");
            pos__ = 0;
            size_t J_item_equal_k_0_max__ = N_item_equal;
            for (size_t k_0__ = 0; k_0__ < J_item_equal_k_0_max__; ++k_0__) {
                J_item_equal[k_0__] = vals_i__[pos__++];
            }
            size_t J_item_equal_i_0_max__ = N_item_equal;
            for (size_t i_0__ = 0; i_0__ < J_item_equal_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_item_equal[i_0__]", J_item_equal[i_0__], 1);
            }
            current_statement_begin__ = 58;
            validate_non_negative_index("J_item_orig", "N_item_equal", N_item_equal);
            context__.validate_dims("data initialization", "J_item_orig", "int", context__.to_vec(N_item_equal));
            J_item_orig = std::vector<int>(N_item_equal, int(0));
            vals_i__ = context__.vals_i("J_item_orig");
            pos__ = 0;
            size_t J_item_orig_k_0_max__ = N_item_equal;
            for (size_t k_0__ = 0; k_0__ < J_item_orig_k_0_max__; ++k_0__) {
                J_item_orig[k_0__] = vals_i__[pos__++];
            }
            size_t J_item_orig_i_0_max__ = N_item_equal;
            for (size_t i_0__ = 0; i_0__ < J_item_orig_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_item_orig[i_0__]", J_item_orig[i_0__], 1);
            }
            current_statement_begin__ = 61;
            context__.validate_dims("data initialization", "ncat", "int", context__.to_vec());
            ncat = int(0);
            vals_i__ = context__.vals_i("ncat");
            pos__ = 0;
            ncat = vals_i__[pos__++];
            check_greater_or_equal(function__, "ncat", ncat, 2);
            current_statement_begin__ = 64;
            validate_non_negative_index("lambda", "N_item", N_item);
            context__.validate_dims("data initialization", "lambda", "vector_d", context__.to_vec(N_item));
            lambda = Eigen::Matrix<double, Eigen::Dynamic, 1>(N_item);
            vals_r__ = context__.vals_r("lambda");
            pos__ = 0;
            size_t lambda_j_1_max__ = N_item;
            for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                lambda(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 65;
            validate_non_negative_index("psi", "N_item", N_item);
            context__.validate_dims("data initialization", "psi", "vector_d", context__.to_vec(N_item));
            psi = Eigen::Matrix<double, Eigen::Dynamic, 1>(N_item);
            vals_r__ = context__.vals_r("psi");
            pos__ = 0;
            size_t psi_j_1_max__ = N_item;
            for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
                psi(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "psi", psi, 0);
            current_statement_begin__ = 66;
            validate_non_negative_index("r", "N_item", N_item);
            context__.validate_dims("data initialization", "r", "vector_d", context__.to_vec(N_item));
            r = Eigen::Matrix<double, Eigen::Dynamic, 1>(N_item);
            vals_r__ = context__.vals_r("r");
            pos__ = 0;
            size_t r_j_1_max__ = N_item;
            for (size_t j_1__ = 0; j_1__ < r_j_1_max__; ++j_1__) {
                r(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 68;
            validate_non_negative_index("gamma", "((primitive_value((primitive_value(logical_eq(family, 1)) || primitive_value(logical_eq(family, 3)))) || primitive_value(logical_eq(family, 4))) ? N_itemC : 0 )", ((primitive_value((primitive_value(logical_eq(family, 1)) || primitive_value(logical_eq(family, 3)))) || primitive_value(logical_eq(family, 4))) ? N_itemC : 0 ));
            context__.validate_dims("data initialization", "gamma", "vector_d", context__.to_vec(((primitive_value((primitive_value(logical_eq(family, 1)) || primitive_value(logical_eq(family, 3)))) || primitive_value(logical_eq(family, 4))) ? N_itemC : 0 )));
            gamma = Eigen::Matrix<double, Eigen::Dynamic, 1>(((primitive_value((primitive_value(logical_eq(family, 1)) || primitive_value(logical_eq(family, 3)))) || primitive_value(logical_eq(family, 4))) ? N_itemC : 0 ));
            vals_r__ = context__.vals_r("gamma");
            pos__ = 0;
            size_t gamma_j_1_max__ = ((primitive_value((primitive_value(logical_eq(family, 1)) || primitive_value(logical_eq(family, 3)))) || primitive_value(logical_eq(family, 4))) ? N_itemC : 0 );
            for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                gamma(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 69;
            validate_non_negative_index("gamma_ord", "(ncat - 1)", (ncat - 1));
            validate_non_negative_index("gamma_ord", "(logical_eq(family, 2) ? N_itemC : 0 )", (logical_eq(family, 2) ? N_itemC : 0 ));
            context__.validate_dims("data initialization", "gamma_ord", "vector_d", context__.to_vec((logical_eq(family, 2) ? N_itemC : 0 ),(ncat - 1)));
            gamma_ord = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >((logical_eq(family, 2) ? N_itemC : 0 ), Eigen::Matrix<double, Eigen::Dynamic, 1>((ncat - 1)));
            vals_r__ = context__.vals_r("gamma_ord");
            pos__ = 0;
            size_t gamma_ord_j_1_max__ = (ncat - 1);
            size_t gamma_ord_k_0_max__ = (logical_eq(family, 2) ? N_itemC : 0 );
            for (size_t j_1__ = 0; j_1__ < gamma_ord_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < gamma_ord_k_0_max__; ++k_0__) {
                    gamma_ord[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            size_t gamma_ord_i_0_max__ = (logical_eq(family, 2) ? N_itemC : 0 );
            for (size_t i_0__ = 0; i_0__ < gamma_ord_i_0_max__; ++i_0__) {
                stan::math::check_ordered(function__, "gamma_ord[i_0__]", gamma_ord[i_0__]);
            }
            current_statement_begin__ = 71;
            validate_non_negative_index("disp", "(logical_eq(family, 4) ? 1 : 0 )", (logical_eq(family, 4) ? 1 : 0 ));
            context__.validate_dims("data initialization", "disp", "vector_d", context__.to_vec((logical_eq(family, 4) ? 1 : 0 )));
            disp = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(family, 4) ? 1 : 0 ));
            vals_r__ = context__.vals_r("disp");
            pos__ = 0;
            size_t disp_j_1_max__ = (logical_eq(family, 4) ? 1 : 0 );
            for (size_t j_1__ = 0; j_1__ < disp_j_1_max__; ++j_1__) {
                disp(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "disp", disp, 0);
            current_statement_begin__ = 73;
            validate_non_negative_index("L_trait", "N_trait", N_trait);
            validate_non_negative_index("L_trait", "N_trait", N_trait);
            context__.validate_dims("data initialization", "L_trait", "matrix_d", context__.to_vec(N_trait,N_trait));
            L_trait = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N_trait, N_trait);
            vals_r__ = context__.vals_r("L_trait");
            pos__ = 0;
            size_t L_trait_j_2_max__ = N_trait;
            size_t L_trait_j_1_max__ = N_trait;
            for (size_t j_2__ = 0; j_2__ < L_trait_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < L_trait_j_1_max__; ++j_1__) {
                    L_trait(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            stan::math::check_cholesky_factor_corr(function__, "L_trait", L_trait);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 79;
            validate_non_negative_index("z_trait", "N_trait", N_trait);
            validate_non_negative_index("z_trait", "N_person", N_person);
            num_params_r__ += (N_trait * N_person);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_thurstonian_irt_model_newdata() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 79;
        if (!(context__.contains_r("z_trait")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_trait missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_trait");
        pos__ = 0U;
        validate_non_negative_index("z_trait", "N_trait", N_trait);
        validate_non_negative_index("z_trait", "N_person", N_person);
        context__.validate_dims("parameter initialization", "z_trait", "matrix_d", context__.to_vec(N_trait,N_person));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> z_trait(N_trait, N_person);
        size_t z_trait_j_2_max__ = N_person;
        size_t z_trait_j_1_max__ = N_trait;
        for (size_t j_2__ = 0; j_2__ < z_trait_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_trait_j_1_max__; ++j_1__) {
                z_trait(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(z_trait);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_trait: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 79;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> z_trait;
            (void) z_trait;  // dummy to suppress unused var warning
            if (jacobian__)
                z_trait = in__.matrix_constrain(N_trait, N_person, lp__);
            else
                z_trait = in__.matrix_constrain(N_trait, N_person);
            // transformed parameters
            current_statement_begin__ = 83;
            validate_non_negative_index("eta", "N_person", N_person);
            validate_non_negative_index("eta", "N_trait", N_trait);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> eta(N_person, N_trait);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 84;
            stan::math::assign(eta, transpose(multiply(L_trait, z_trait)));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 83;
            size_t eta_j_1_max__ = N_person;
            size_t eta_j_2_max__ = N_trait;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(eta(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: eta" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            {
            current_statement_begin__ = 87;
            validate_non_negative_index("mu", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(N);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 88;
            validate_non_negative_index("sum_psi", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sum_psi(N);
            stan::math::initialize(sum_psi, DUMMY_VAR__);
            stan::math::fill(sum_psi, DUMMY_VAR__);
            current_statement_begin__ = 89;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 91;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            (((get_base1(r, get_base1(J_item1, n, "J_item1", 1), "r", 1) - get_base1(r, get_base1(J_item2, n, "J_item2", 1), "r", 1)) + (get_base1(lambda, get_base1(J_item1, n, "J_item1", 1), "lambda", 1) * get_base1(eta, get_base1(J_person, n, "J_person", 1), get_base1(J_trait1, n, "J_trait1", 1), "eta", 1))) - (get_base1(lambda, get_base1(J_item2, n, "J_item2", 1), "lambda", 1) * get_base1(eta, get_base1(J_person, n, "J_person", 1), get_base1(J_trait2, n, "J_trait2", 1), "eta", 1))), 
                            "assigning variable mu");
                current_statement_begin__ = 95;
                stan::model::assign(sum_psi, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            stan::math::sqrt((pow(get_base1(psi, get_base1(J_item1, n, "J_item1", 1), "psi", 1), 2) + pow(get_base1(psi, get_base1(J_item2, n, "J_item2", 1), "psi", 1), 2))), 
                            "assigning variable sum_psi");
            }
            current_statement_begin__ = 98;
            if (as_bool(logical_eq(family, 1))) {
                current_statement_begin__ = 100;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 102;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                Phi(((get_base1(mu, n, "mu", 1) - get_base1(gamma, get_base1(J_itemC, n, "J_itemC", 1), "gamma", 1)) / get_base1(sum_psi, n, "sum_psi", 1))), 
                                "assigning variable mu");
                }
                current_statement_begin__ = 104;
                lp_accum__.add(bernoulli_log<propto__>(Yint, mu));
            } else if (as_bool(logical_eq(family, 2))) {
                current_statement_begin__ = 107;
                for (int n = 1; n <= N; ++n) {
                    {
                    current_statement_begin__ = 109;
                    validate_non_negative_index("thres", "(ncat - 1)", (ncat - 1));
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> thres((ncat - 1));
                    stan::math::initialize(thres, DUMMY_VAR__);
                    stan::math::fill(thres, DUMMY_VAR__);
                    stan::math::assign(thres,divide(get_base1(gamma_ord, get_base1(J_itemC, n, "J_itemC", 1), "gamma_ord", 1), get_base1(sum_psi, n, "sum_psi", 1)));
                    current_statement_begin__ = 110;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), "mu") / get_base1(sum_psi, n, "sum_psi", 1)), 
                                "assigning variable mu");
                    current_statement_begin__ = 112;
                    lp_accum__.add(cumulative_Phi_lpmf<propto__>(get_base1(Yint, n, "Yint", 1), get_base1(mu, n, "mu", 1), thres, pstream__));
                    }
                }
            } else if (as_bool(logical_eq(family, 3))) {
                current_statement_begin__ = 116;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 117;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                (get_base1(mu, n, "mu", 1) - get_base1(gamma, get_base1(J_itemC, n, "J_itemC", 1), "gamma", 1)), 
                                "assigning variable mu");
                }
                current_statement_begin__ = 120;
                lp_accum__.add(normal_log<propto__>(Yreal, mu, 1));
            } else if (as_bool(logical_eq(family, 4))) {
                current_statement_begin__ = 123;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 124;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                Phi(((get_base1(mu, n, "mu", 1) - get_base1(gamma, get_base1(J_itemC, n, "J_itemC", 1), "gamma", 1)) / get_base1(sum_psi, n, "sum_psi", 1))), 
                                "assigning variable mu");
                }
                current_statement_begin__ = 126;
                lp_accum__.add(beta_log<propto__>(Yreal, multiply(mu, get_base1(disp, 1, "disp", 1)), multiply(subtract(1, mu), get_base1(disp, 1, "disp", 1))));
            }
            current_statement_begin__ = 129;
            if (as_bool(logical_eq(family, 2))) {
                current_statement_begin__ = 130;
                for (int i = 1; i <= N_itemC; ++i) {
                    current_statement_begin__ = 131;
                    lp_accum__.add(normal_log<propto__>(get_base1(gamma_ord, i, "gamma_ord", 1), 0, 3));
                }
            } else {
                current_statement_begin__ = 134;
                lp_accum__.add(normal_log<propto__>(gamma, 0, 3));
            }
            current_statement_begin__ = 136;
            lp_accum__.add(normal_log<propto__>(to_vector(z_trait), 0, 1));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("z_trait");
        names__.push_back("eta");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(N_trait);
        dims__.push_back(N_person);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_person);
        dims__.push_back(N_trait);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_thurstonian_irt_model_newdata_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> z_trait = in__.matrix_constrain(N_trait, N_person);
        size_t z_trait_j_2_max__ = N_person;
        size_t z_trait_j_1_max__ = N_trait;
        for (size_t j_2__ = 0; j_2__ < z_trait_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_trait_j_1_max__; ++j_1__) {
                vars__.push_back(z_trait(j_1__, j_2__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 83;
            validate_non_negative_index("eta", "N_person", N_person);
            validate_non_negative_index("eta", "N_trait", N_trait);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eta(N_person, N_trait);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 84;
            stan::math::assign(eta, transpose(multiply(L_trait, z_trait)));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t eta_j_2_max__ = N_trait;
                size_t eta_j_1_max__ = N_person;
                for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                        vars__.push_back(eta(j_1__, j_2__));
                    }
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_thurstonian_irt_model_newdata";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t z_trait_j_2_max__ = N_person;
        size_t z_trait_j_1_max__ = N_trait;
        for (size_t j_2__ = 0; j_2__ < z_trait_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_trait_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_trait" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t eta_j_2_max__ = N_trait;
            size_t eta_j_1_max__ = N_person;
            for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t z_trait_j_2_max__ = N_person;
        size_t z_trait_j_1_max__ = N_trait;
        for (size_t j_2__ = 0; j_2__ < z_trait_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < z_trait_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_trait" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t eta_j_2_max__ = N_trait;
            size_t eta_j_1_max__ = N_person;
            for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_thurstonian_irt_model_newdata_namespace::model_thurstonian_irt_model_newdata stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
