% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_message.R
\name{parse_inline_expressions}
\alias{parse_inline_expressions}
\title{Parse inline expressions}
\usage{
parse_inline_expressions(text, env = parent.frame())
}
\arguments{
\item{text}{A character string containing inline expressions to parse.}

\item{env}{Environment in which to evaluate expressions.
Defaults to the calling environment.}
}
\value{
A character string with expressions evaluated but formatting preserved.
}
\description{
Parse `{}` inline expressions and evaluate them in the current environment,
while preserving outer formatting markers like `\{.val ...\}`.
}
\examples{
i <- 1
parse_inline_expressions(
  "{.val {i}}"
)

x <- 5
y <- 10
parse_inline_expressions(
  "{.pkg {x + y}}"
)

name <- "testing"
name <- parse_inline_expressions(
  "{.pkg {name}}"
)
name

log_message(name)
}
