#' Adaptation of Adolescent Immigrants in Greece
#'
#' This simulated dataset, based on work
#' by Motti-Stefanidi and colleagues (2012),
#' assesses the adaptation and well-being of adolescent immigrants in Greek
#' schools.
#'
#' \tabular{lll}{
#'   \strong{GRK1} \tab \code{ordered} \tab Greek language ability at age 13\cr
#'   \strong{IMM1} \tab \code{ordered} \tab Immigrant status at age 13 (0 = no, 1 = yes)\cr
#'   \strong{ADV1} \tab \code{ordered} \tab Adversity at age 13\cr
#'   \strong{INV1} \tab \code{ordered} \tab Parental School Involvement at age 13\cr
#'   \strong{SEF1} \tab \code{ordered} \tab Self-efficacy at age 13\cr
#'   \strong{GPA1} \tab \code{ordered} \tab Academic achievement at age 13\cr
#'   \strong{GPA2} \tab \code{ordered} \tab Academic achievement at age 14\cr
#'   \strong{GPA3} \tab \code{ordered} \tab Academic achievement at age 15\cr
#'   \strong{CON1} \tab \code{ordered} \tab Conduct at age 13\cr
#'   \strong{CON2} \tab \code{ordered} \tab Conduct at age 14\cr
#'   \strong{CON3} \tab \code{ordered} \tab Conduct at age 15\cr
#'   \strong{EMO1} \tab \code{ordered} \tab Emotional symptoms at age 13\cr
#'   \strong{EMO2} \tab \code{ordered} \tab Emotional symptoms at age 14\cr
#'   \strong{EMO3} \tab \code{ordered} \tab Emotional symptoms at age 15\cr
#'   \strong{POP1} \tab \code{numeric} \tab Peer popularity at age 13\cr
#'   \strong{POP2} \tab \code{numeric} \tab Peer popularity at age 14\cr
#'   \strong{POP3} \tab \code{numeric} \tab Peer popularity at age 15
#' }
#' @docType data
#' @keywords datasets
#' @name mottistefanidi2012
#' @usage data(mottistefanidi2012)
#' @references Motti-Stefanidi, F., Asendorpf, J. B., & Masten, A. S. (2012). The adaptation and well-being of adolescent immigrants in Greek schools: A multilevel, longitudinal study of risks and resources. Development and Psychopathology, 24(2), 451–473.
#' \doi{10.1017/S0954579412000090}
#' @format A data frame with 1057 rows and 17 variables.
"mottistefanidi2012"
