% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfrmt_n_pct.R
\name{tfrmt_n_pct}
\alias{tfrmt_n_pct}
\title{N Percent Template}
\usage{
tfrmt_n_pct(
  n = "n",
  pct = "pct",
  pct_frmt_when = frmt_when("==100" ~ frmt(""), ">99" ~ frmt("(>99\%)"), "==0" ~ "", "<1"
    ~ frmt("(<1\%)"), "TRUE" ~ frmt("(xx.x\%)")),
  tfrmt_obj = NULL
)
}
\arguments{
\item{n}{name of count (n) value in the parameter column}

\item{pct}{name of percent (pct) value in the parameter column}

\item{pct_frmt_when}{formatting to be used on the the percent values}

\item{tfrmt_obj}{an optional tfrmt object to layer}
}
\value{
tfrmt object
}
\description{
This function creates an tfrmt for an n \% table, so count based table. The
parameter values for n and percent can be provided (by default it will assume
\code{n} and \code{pct}). Additionally the \code{frmt_when} for formatting the percent can
be specified. By default 100\% and 0\% will not appear and everything between
99\% and 100\% and 0\% and 1\% will be rounded using greater than (>) and less
than (<) signs respectively.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{print_mock_gt(tfrmt_n_pct())
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/GSK-Biostatistics/tfrmt/master/images/example_n_percent.png" alt="3 by 3 table" style="width:50\%;">
}}
}

