% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-methods.R
\name{tfd_sample}
\alias{tfd_sample}
\title{Generate samples of the specified shape.}
\usage{
tfd_sample(distribution, sample_shape = list(), seed = NULL,
  name = "sample")
}
\arguments{
\item{distribution}{The distribution being used.}

\item{sample_shape}{0D or 1D int32 Tensor. Shape of the generated samples.}

\item{seed}{integer seed for RNG}

\item{name}{name to give to the op.}
}
\value{
a Tensor with prepended dimensions sample_shape.
}
\description{
Note that a call to \code{tfd_sample()} without arguments will generate a single sample.
}
\examples{
\donttest{
  d <- tfd_normal(loc = c(1, 2), scale = c(1, 0.5))
  d \%>\% tfd_sample()
}
}
\seealso{
Other distribution_methods: \code{\link{tfd_cdf}},
  \code{\link{tfd_covariance}},
  \code{\link{tfd_cross_entropy}},
  \code{\link{tfd_entropy}},
  \code{\link{tfd_kl_divergence}},
  \code{\link{tfd_log_cdf}}, \code{\link{tfd_log_prob}},
  \code{\link{tfd_log_survival_function}},
  \code{\link{tfd_mean}}, \code{\link{tfd_mode}},
  \code{\link{tfd_prob}}, \code{\link{tfd_quantile}},
  \code{\link{tfd_stddev}},
  \code{\link{tfd_survival_function}},
  \code{\link{tfd_variance}}
}
\concept{distribution_methods}
