% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet_dataset.R
\name{parquet_dataset}
\alias{parquet_dataset}
\title{Create a \code{ParquetDataset}.}
\usage{
parquet_dataset(filenames, columns, output_types)
}
\arguments{
\item{filenames}{A 0-D or 1-D \code{tf.string} tensor containing one or more
filenames.}

\item{columns}{A 0-D or 1-D \code{tf.int32} tensor containing the columns to
extract.}

\item{output_types}{A tuple of \code{tf.DType} objects representing the types of
the columns returned.}
}
\description{
This allows a user to read data from a parquet file.
}
\examples{
\dontrun{
dtypes <- tf$python$framework$dtypes
output_types <- reticulate::tuple(
  dtypes$bool, dtypes$int32, dtypes$int64, dtypes$float32, dtypes$float64)
dataset <- parquet_dataset(
    filenames = list("testdata/parquet_cpp_example.parquet"),
    columns = list(0, 1, 2, 4, 5),
    output_types = output_types) \%>\%
  dataset_repeat(2)

sess <- tf$Session()
iterator <- make_iterator_one_shot(dataset)
next_batch <- iterator_get_next(iterator)

until_out_of_range({
  batch <- sess$run(next_batch)
  print(batch)
})
}

}
