% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_map.R
\name{tf_map}
\alias{tf_map}
\title{\code{tf.map_fn()}}
\usage{
tf_map(
  elems,
  fn,
  dtype = NULL,
  parallel_iterations = NULL,
  back_prop = TRUE,
  swap_memory = FALSE,
  infer_shape = TRUE,
  name = NULL
)
}
\arguments{
\item{elems}{A tensor or (possibly nested) sequence of tensors, each of which
will be unpacked along their first dimension. The nested sequence of the
resulting slices will be applied to \code{fn}.}

\item{fn}{An R function, specified using \code{purrr} style ~ syntax, a character
string, a python function (or more generally, any python object with a
\verb{__call__} method) or anything coercible via \code{as.function()}. The function
will be be called with one argument, which will have the same (possibly
nested) structure as \code{elems}. Its output must return the same structure as
\code{dtype} if one is provided, otherwise it must return the same structure as
\code{elems}.}

\item{dtype}{(optional) The output type(s) of fn. If fn returns a structure
of Tensors differing from the structure of elems, then dtype is not
optional and must have the same structure as the output of fn.}

\item{parallel_iterations}{(optional) The number of iterations allowed to
run in parallel. When graph building, the default value is 10. While
executing eagerly, the default value is set to 1.}

\item{back_prop}{(optional) True enables support for back propagation.}

\item{swap_memory}{(optional) True enables GPU-CPU memory swapping.}

\item{infer_shape}{(optional) False disables tests for consistent output
shapes.}

\item{name}{(optional) Name prefix for the returned tensors.}
}
\value{
A tensor or (possibly nested) sequence of tensors. Each tensor packs
the results of applying fn to tensors unpacked from elems along the first
dimension, from first to last.
}
\description{
Thin wrapper around \code{tf.map_fn()} with the following
differences:
\itemize{
\item accepts \code{purrr} style \code{~} lambda syntax to define function \code{fn}.
\item The order of \code{elems} and \code{fn} is switched to make it more pipe \verb{\%>\%}
friendly and consistent with R mappers \code{lapply()} and \code{purrr::map()}.
}
}
