% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{stsm}
\alias{stsm}
\title{Structural Time Series models}
\usage{
stsm(y, b, C, fSv, s2v, s2u = 1, xreg = NULL, bc = FALSE, fit = TRUE, ...)
}
\arguments{
\item{y}{an object of class \code{ts}.}

\item{b}{vector of constants.}

\item{C}{matrix of constants.}

\item{fSv}{function to create the covariance matrix of v_t.}

\item{s2v}{variances of the vector error v_t in the state equation.}

\item{s2u}{variance of the error u_t in the observation equation.}

\item{xreg}{matrix of regressors.}

\item{bc}{logical. If TRUE logs are taken.}

\item{fit}{logical. If TRUE, model is fitted.}

\item{...}{other arguments.}
}
\value{
An object of class \code{stsm}.
}
\description{
\code{stsm} creates an S3 object representing a time-invariant structural
time series model.
}
\details{
y_t = b'x_t + u_t (observation equation), 
x_t = Cx_t-1 + v_t (state equation).
}
\examples{
# Local level model
b <- 1
C <- as.matrix(1)
stsm1 <- stsm(Nile, b, C, s2v = c(lvl = 0.5), s2u = c(irr = 1))
stsm1
}
\references{
Durbin, J. and Koopman, S.J. (2012) Time Series Analysis
}
