% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_tokens.R
\name{show_tokens}
\alias{show_tokens}
\title{Show token output of recipe}
\usage{
show_tokens(rec, var, n = 6L)
}
\arguments{
\item{rec}{A recipe object}

\item{var}{name of variable}

\item{n}{Number of elements to return.}
}
\value{
A list of character vectors
}
\description{
Returns the tokens as a list of character vectors of a recipe. This function
can be useful for diagnostics during recipe construction but should not be
used in final recipe steps. Note that this function will both prep() and
bake() the recipe it is used on.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
text_tibble <- tibble(text = c("This is words", "They are nice!"))

recipe(~text, data = text_tibble) \%>\%
  step_tokenize(text) \%>\%
  show_tokens(text)

library(modeldata)
data(tate_text)

recipe(~., data = tate_text) \%>\%
  step_tokenize(medium) \%>\%
  show_tokens(medium)
\dontshow{\}) # examplesIf}
}
