% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embeddings.R
\name{step_word_embeddings}
\alias{step_word_embeddings}
\title{Pretrained Word Embeddings of Tokens}
\usage{
step_word_embeddings(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  embeddings,
  aggregation = c("sum", "mean", "min", "max"),
  aggregation_default = 0,
  prefix = "wordembed",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("word_embeddings")
)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be
used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{embeddings}{A tibble of pre-trained word embeddings, such as those
returned by the embedding_glove function from the textdata package. The
first column should contain tokens, and additional columns should contain
embeddings vectors.}

\item{aggregation}{A character giving the name of the aggregation function to
use. Must be one of "sum", "mean", "min", and "max". Defaults to "sum".}

\item{aggregation_default}{A numeric denoting the default value for case with
no words are matched in embedding. Defaults to 0.}

\item{prefix}{A character string that will be the prefix to the
resulting new variables. See notes below.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_word_embeddings} creates a \emph{specification} of a recipe step that will
convert a \code{\link[=tokenlist]{token}} variable into word-embedding dimensions by
aggregating the vectors of each token from a pre-trained embedding.
}
\details{
Word embeddings map words (or other tokens) into a high-dimensional feature
space. This function maps pre-trained word embeddings onto the tokens in your
data.

The argument \code{embeddings} provides the pre-trained vectors. Each dimension
present in this tibble becomes a new feature column, with each column
aggregated across each row of your text using the function supplied in the
\code{aggregation} argument.

The new components will have names that begin with \code{prefix}, then the name of
the aggregation function, then the name of the variable from the embeddings
tibble (usually something like "d7"). For example, using the default
"wordembedding" prefix, and the GloVe embeddings from the textdata package
(where the column names are \code{d1}, \code{d2}, etc), new columns would be
\code{wordembedding_d1}, \code{wordembedding_d1}, etc.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected), \code{embedding_rows} (number of rows in
embedding), and \code{aggregation} (the aggregation method).
}

\examples{
library(recipes)

embeddings <- tibble(
  tokens = c("the", "cat", "ran"),
  d1 = c(1, 0, 0),
  d2 = c(0, 1, 0),
  d3 = c(0, 0, 1)
)

sample_data <- tibble(
  text = c(
    "The.",
    "The cat.",
    "The cat ran."
  ),
  text_label = c("fragment", "fragment", "sentence")
)

rec <- recipe(text_label ~ ., data = sample_data) \%>\%
  step_tokenize(text) \%>\%
  step_word_embeddings(text, embeddings = embeddings)

obj <- rec \%>\%
  prep()

bake(obj, sample_data)

tidy(rec, number = 2)
tidy(obj, number = 2)
}
\seealso{
\code{\link[=step_tokenize]{step_tokenize()}} to turn characters into \code{\link[=tokenlist]{tokens}}

Other Steps for Numeric Variables From Tokens: 
\code{\link{step_lda}()},
\code{\link{step_texthash}()},
\code{\link{step_tfidf}()},
\code{\link{step_tf}()}
}
\concept{Steps for Numeric Variables From Tokens}
