% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pos_filter.R
\name{step_pos_filter}
\alias{step_pos_filter}
\alias{tidy.step_pos_filter}
\title{Part of speech filtering of \link{tokenlist} variables}
\usage{
step_pos_filter(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  keep_tags = "NOUN",
  skip = FALSE,
  id = rand_id("pos_filter")
)

\method{tidy}{step_pos_filter}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.
For \code{step_pos_filter}, this indicates the variables to be encoded
into a \link{tokenlist}. See \code{\link[recipes:selections]{recipes::selections()}} for more
details. For the \code{tidy} method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the recipe has been
baked.}

\item{columns}{A list of tibble results that define the
encoding. This is \code{NULL} until the step is trained by
\code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{keep_tags}{Character variable of part of speech tags to keep. See
details for complete list of tags. Defaults to "NOUN".}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all
operations are baked when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some
operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when
using \code{skip = TRUE} as it may affect the computations for
subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_pos_filter} object.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_pos_filter} creates a \emph{specification} of a recipe step that
will filter a \link{tokenlist} based on part of speech tags.
}
\details{
Possible part of speech tags for \code{spacyr} engine are: "ADJ", "ADP", "ADV",
"AUX", "CONJ", "CCONJ", "DET", "INTJ", "NOUN", "NUM", "PART", "PRON",
"PROPN", "PUNCT", "SCONJ", "SYM", "VERB", "X" and "SPACE". For more
information look here \url{https://spacy.io/api/annotation#pos-tagging}.
}
\examples{
\dontrun{
library(recipes)

short_data <- data.frame(text = c(
  "This is a short tale,",
  "With many cats and ladies."
))

okc_rec <- recipe(~text, data = short_data) \%>\%
  step_tokenize(text, engine = "spacyr") \%>\%
  step_pos_filter(text, keep_tags = "NOUN") \%>\%
  step_tf(text)

okc_obj <- prep(okc_rec)

bake(okc_obj, new_data = NULL)
}
}
\seealso{
\code{\link[=step_tokenize]{step_tokenize()}} to turn character into tokenlist.

Other tokenlist to tokenlist steps: 
\code{\link{step_lemma}()},
\code{\link{step_ngram}()},
\code{\link{step_stem}()},
\code{\link{step_stopwords}()},
\code{\link{step_tokenfilter}()},
\code{\link{step_tokenmerge}()}
}
\concept{tokenlist to tokenlist steps}
