% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling_core.R
\name{predict.ctm_topic_model}
\alias{predict.ctm_topic_model}
\title{Predict method for Correlated topic models (CTM)}
\usage{
\method{predict}{ctm_topic_model}(object, newdata, ...)
}
\arguments{
\item{object}{a fitted object of class "ctm_topic_model"}

\item{newdata}{a DTM or TCM of class dgCMatrix or a numeric vector}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a "theta" matrix with one row per document and one column per topic
}
\description{
Obtains predictions of topics for new documents from a fitted CTM model
}
\note{
Predictions for this method are performed using the "dot" method as described
in the textmineR vignette "c_topic_modeling".
}
\examples{
# Load a pre-formatted dtm 
data(nih_sample_dtm) 

model <- FitCtmModel(dtm = nih_sample_dtm[1:20,], k = 3,
                     calc_coherence = FALSE, calc_r2 = FALSE)

# Get predictions on the next 50 documents
pred <- predict(model, nih_sample_dtm[21:100,])
}
