% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tts_auth.R
\name{tts_auth}
\alias{tts_auth}
\alias{tts_amazon_auth}
\alias{tts_google_auth}
\alias{tts_microsoft_auth}
\alias{tts_coqui_auth}
\title{Authentication for Text-to-Speech (Speech Synthesis) Engines}
\usage{
tts_auth(
  service = c("amazon", "google", "microsoft", "coqui"),
  key_or_json_file = NULL,
  ...
)

tts_amazon_auth(key_or_json_file = NULL, ...)

tts_google_auth(key_or_json_file = NULL, ...)

tts_microsoft_auth(key_or_json_file = NULL, ...)

tts_coqui_auth()
}
\arguments{
\item{service}{Service to use (Amazon, Google, Microsoft, or Coqui)}

\item{key_or_json_file}{Either an API key (for Microsoft) or JSON file (for
Google)}

\item{...}{Additional arguments}
}
\value{
A logical indicator of authorization
}
\description{
Verify the authentication status of different text-to-speech
engines, including Amazon Polly, Coqui TTS, Google Cloud Text-to-Speech API,
and Microsoft Cognitive Services Text to Speech REST API.
}
\details{
To determine the availability of Coqui TTS, \code{tts_auth()} examines whether the tts
executable exists on local system.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Amazon Polly
tts_auth("amazon")

# Google Cloud Text-to-Speech API
tts_auth("google")

# Microsoft Cognitive Services Text to Speech REST API
tts_auth("microsoft")

# Coqui TTS
tts_auth("coqui")
\dontshow{\}) # examplesIf}
}
