% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{voronoi}
\alias{voronoi}
\title{Voronoï tessellation}
\usage{
voronoi(tessellation)
}
\arguments{
\item{tessellation}{output of \code{\link{delaunay}}}
}
\value{
A list of pairs representing the Voronoï tessellation. Each
  \code{\link[sets]{pair}} is named: the first component is called
  \code{"site"}, and the second component is called \code{"cell"}.
}
\description{
Voronoï tessellation from Delaunay tessellation; this is a list
  of pairs made of a site (a vertex) and a list of edges.
}
\examples{
library(tessellation)
d <- delaunay(centricCuboctahedron())
v <- voronoi(d)
# the Voronoï diagram has 13 cells (one for each site):
length(v)
# there is only one bounded cell:
length(Filter(isBoundedCell, v)) # or attr(v, "nbounded")
}
\seealso{
\code{\link{isBoundedCell}}, \code{\link{cellVertices}},
  \code{\link{plotBoundedCell2D}}, \code{\link{plotBoundedCell3D}}
}
