% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_lineplot.R
\name{g_lineplot}
\alias{g_lineplot}
\title{Line plot with the optional table}
\usage{
g_lineplot(
  df,
  alt_counts_df = NULL,
  variables = control_lineplot_vars(),
  mid = "mean",
  interval = "mean_ci",
  whiskers = c("mean_ci_lwr", "mean_ci_upr"),
  table = NULL,
  sfun = tern::s_summary,
  ...,
  mid_type = "pl",
  mid_point_size = 2,
  position = ggplot2::position_dodge(width = 0.4),
  legend_title = NULL,
  legend_position = "bottom",
  ggtheme = nestcolor::theme_nest(),
  x_lab = obj_label(df[[variables[["x"]]]]),
  y_lab = NULL,
  y_lab_add_paramcd = TRUE,
  y_lab_add_unit = TRUE,
  title = "Plot of Mean and 95\% Confidence Limits by Visit",
  subtitle = "",
  subtitle_add_paramcd = TRUE,
  subtitle_add_unit = TRUE,
  caption = NULL,
  table_format = summary_formats(),
  table_labels = summary_labels(),
  table_font_size = 3,
  newpage = TRUE,
  col = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{alt_counts_df}{(\code{data.frame} or \code{NULL})\cr data set that will be used (only)
to counts objects in groups for stratification.}

\item{variables}{(named \code{character} vector) of variable names in \code{df} data set. Details are:
\itemize{
\item \code{x} (\code{character})\cr name of x-axis variable.
\item \code{y} (\code{character})\cr name of y-axis variable.
\item \code{group_var} (\code{character})\cr name of grouping variable (or strata), i.e. treatment arm.
Can be \code{NA} to indicate lack of groups.
\item \code{subject_var} (\code{character})\cr name of subject variable. Only applies if \code{group_var} is
not NULL.
\item \code{paramcd} (\code{character})\cr name of the variable for parameter's code. Used for y-axis label and plot's subtitle.
Can be \code{NA} if \code{paramcd} is not to be added to the y-axis label or subtitle.
\item \code{y_unit} (\code{character})\cr name of variable with units of \code{y}. Used for y-axis label and plot's subtitle.
Can be \code{NA} if y unit is not to be added to the y-axis label or subtitle.
}}

\item{mid}{(\code{character} or \code{NULL})\cr names of the statistics that will be plotted as midpoints.
All the statistics indicated in \code{mid} variable must be present in the object returned by \code{sfun},
and be of a \code{double} or \code{numeric} type vector of length one.}

\item{interval}{(\code{character} or \code{NULL})\cr names of the statistics that will be plotted as intervals.
All the statistics indicated in \code{interval} variable must be present in the object returned by \code{sfun},
and be of a \code{double} or \code{numeric} type vector of length two. Set \code{interval = NULL} if intervals should not be
added to the plot.}

\item{whiskers}{(\code{character})\cr names of the interval whiskers that will be plotted. Names must match names
of the list element \code{interval} that will be returned by \code{sfun} (e.g. \code{mean_ci_lwr} element of
\code{sfun(x)[["mean_ci"]]}). It is possible to specify one whisker only, or to suppress all whiskers by setting
\code{interval = NULL}.}

\item{table}{(\code{character} or \code{NULL})\cr names of the statistics that will be displayed in the table below the plot.
All the statistics indicated in \code{table} variable must be present in the object returned by \code{sfun}.}

\item{sfun}{(\code{closure})\cr the function to compute the values of required statistics. It must return a named \code{list}
with atomic vectors. The names of the \code{list} elements refer to the names of the statistics and are used by \code{mid},
\code{interval}, \code{table}. It must be able to accept as input a vector with data for which statistics are computed.}

\item{...}{optional arguments to \code{sfun}.}

\item{mid_type}{(\code{character})\cr controls the type of the \code{mid} plot, it can be point (\code{p}), line (\code{l}),
or point and line (\code{pl}).}

\item{mid_point_size}{(\code{integer} or \code{double})\cr controls the font size of the point for \code{mid} plot.}

\item{position}{(\code{character} or \code{call})\cr geom element position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{legend_title}{(\code{character} string)\cr legend title.}

\item{legend_position}{(\code{character})\cr the position of the plot legend (\code{none}, \code{left}, \code{right}, \code{bottom}, \code{top},
or two-element numeric vector).}

\item{ggtheme}{(\code{theme})\cr a graphical theme as provided by \code{ggplot2} to control styling of the plot.}

\item{x_lab}{(\code{character})\cr x-axis label. If equal to \code{NULL}, then no label will be added.}

\item{y_lab}{(\code{character})\cr y-axis label. If equal to \code{NULL}, then no label will be added.}

\item{y_lab_add_paramcd}{(\code{logical})\cr should \code{paramcd}, i.e. \code{unique(df[[variables["paramcd"]]])} be added to the
y-axis label \code{y_lab}?}

\item{y_lab_add_unit}{(\code{logical})\cr should y unit, i.e. \code{unique(df[[variables["y_unit"]]])} be added to the y-axis
label \code{y_lab}?}

\item{title}{(\code{character})\cr plot title.}

\item{subtitle}{(\code{character})\cr plot subtitle.}

\item{subtitle_add_paramcd}{(\code{logical})\cr should \code{paramcd}, i.e. \code{unique(df[[variables["paramcd"]]])} be added to
the plot's subtitle \code{subtitle}?}

\item{subtitle_add_unit}{(\code{logical})\cr should y unit, i.e. \code{unique(df[[variables["y_unit"]]])} be added to the
plot's subtitle \code{subtitle}?}

\item{caption}{(\code{character})\cr optional caption below the plot.}

\item{table_format}{(named \code{character} or \code{NULL})\cr format patterns for descriptive statistics used in the
(optional) table appended to the plot. It is passed directly to the \code{h_format_row} function through the \code{format}
parameter. Names of \code{table_format} must match the names of statistics returned by \code{sfun} function.}

\item{table_labels}{(named \code{character} or \code{NULL})\cr labels for descriptive statistics used in the (optional) table
appended to the plot. Names of \code{table_labels} must match the names of statistics returned by \code{sfun} function.}

\item{table_font_size}{(\code{integer} or \code{double})\cr controls the font size of values in the table.}

\item{newpage}{(\code{logical})\cr should plot be drawn on new page?}

\item{col}{(\code{character})\cr colors.}
}
\value{
A \code{ggplot} line plot (and statistics table if applicable).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Line plot with the optional table.
}
\examples{
library(nestcolor)

adsl <- tern_ex_adsl
adlb <- tern_ex_adlb \%>\% dplyr::filter(ANL01FL == "Y", PARAMCD == "ALT", AVISIT != "SCREENING")
adlb$AVISIT <- droplevels(adlb$AVISIT)
adlb <- dplyr::mutate(adlb, AVISIT = forcats::fct_reorder(AVISIT, AVISITN, min))

# Mean with CI
g_lineplot(adlb, adsl, subtitle = "Laboratory Test:")

# Mean with CI, no stratification with group_var
g_lineplot(adlb, variables = control_lineplot_vars(group_var = NA))

# Mean, upper whisker of CI, no group_var(strata) counts N
g_lineplot(
  adlb,
  whiskers = "mean_ci_upr",
  title = "Plot of Mean and Upper 95\% Confidence Limit by Visit"
)

# Median with CI
g_lineplot(
  adlb,
  adsl,
  mid = "median",
  interval = "median_ci",
  whiskers = c("median_ci_lwr", "median_ci_upr"),
  title = "Plot of Median and 95\% Confidence Limits by Visit"
)

# Mean, +/- SD
g_lineplot(adlb, adsl,
  interval = "mean_sdi",
  whiskers = c("mean_sdi_lwr", "mean_sdi_upr"),
  title = "Plot of Median +/- SD by Visit"
)

# Mean with CI plot with stats table
g_lineplot(adlb, adsl, table = c("n", "mean", "mean_ci"))

# Mean with CI, table and customized confidence level
g_lineplot(
  adlb,
  adsl,
  table = c("n", "mean", "mean_ci"),
  control = control_analyze_vars(conf_level = 0.80),
  title = "Plot of Mean and 80\% Confidence Limits by Visit"
)

# Mean with CI, table, filtered data
adlb_f <- dplyr::filter(adlb, ARMCD != "ARM A" | AVISIT == "BASELINE")
g_lineplot(adlb_f, table = c("n", "mean"))

}
