% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_survival.R
\name{control_coxph}
\alias{control_coxph}
\title{Control Function for \code{CoxPH} Model}
\usage{
control_coxph(
  pval_method = c("log-rank", "wald", "likelihood"),
  ties = c("efron", "breslow", "exact"),
  conf_level = 0.95
)
}
\arguments{
\item{pval_method}{(\code{string})\cr p-value method for testing hazard ratio = 1.
Default method is \code{"log-rank"}, can also be set to \code{"wald"} or \code{"likelihood"}.}

\item{ties}{(\code{string})\cr specifying the method for tie handling. Default is \code{"efron"},
can also be set to \code{"breslow"} or \code{"exact"}. See more in \code{\link[survival:coxph]{survival::coxph()}}.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}
}
\value{
A list of components with the same names as the arguments
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is an auxiliary function for controlling arguments for \code{CoxPH} model, typically used internally to specify
details of \code{CoxPH} model for \code{\link[=s_coxph_pairwise]{s_coxph_pairwise()}}. \code{conf_level} refers to Hazard Ratio estimation.
}
