% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_factor.R
\name{cut_quantile_bins}
\alias{cut_quantile_bins}
\title{Cutting Numeric Vector into Empirical Quantile Bins}
\usage{
cut_quantile_bins(
  x,
  probs = c(0.25, 0.5, 0.75),
  labels = NULL,
  type = 7,
  ordered = TRUE
)
}
\arguments{
\item{x}{(\code{numeric})\cr the continuous variable values which should be cut into
quantile bins. This may contain \code{NA} values, which are then
not used for the quantile calculations, but included in the return vector.}

\item{probs}{(\code{proportion} vector)\cr the probabilities identifying the quantiles.
This is a sorted vector of unique \code{proportion} values, i.e. between 0 and 1, where
the boundaries 0 and 1 must not be included.}

\item{labels}{(\code{character})\cr the unique labels for the quantile bins. When there are \code{n}
probabilities in \code{probs}, then this must be \code{n + 1} long.}

\item{type}{(\code{integer})\cr type of quantiles to use, see \code{\link[stats:quantile]{stats::quantile()}} for details.}

\item{ordered}{(\code{flag})\cr should the result be an ordered factor.}
}
\value{
A \code{factor} variable with appropriately-labeled bins as levels.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This cuts a numeric vector into sample quantile bins.
}
\note{
Intervals are closed on the right side. That is, the first bin is the interval
\verb{[-Inf, q1]} where \code{q1} is the first quantile, the second bin is then \verb{(q1, q2]}, etc.,
and the last bin is \verb{(qn, +Inf]} where \code{qn} is the last quantile.
}
\examples{
# Default is to cut into quartile bins.
cut_quantile_bins(cars$speed)

# Use custom quantiles.
cut_quantile_bins(cars$speed, probs = c(0.1, 0.2, 0.6, 0.88))

# Use custom labels.
cut_quantile_bins(cars$speed, labels = paste0("Q", 1:4))

# NAs are preserved in result factor.
ozone_binned <- cut_quantile_bins(airquality$Ozone)
which(is.na(ozone_binned))
# So you might want to make these explicit.
explicit_na(ozone_binned)

}
