% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_patients_with_flags.R
\name{count_patients_with_flags}
\alias{count_patients_with_flags}
\alias{s_count_patients_with_flags}
\alias{a_count_patients_with_flags}
\title{Count the Number of Patients with Particular Flags}
\usage{
s_count_patients_with_flags(
  df,
  .var,
  flag_variables,
  .N_col,
  .N_row,
  denom = c("n", "N_row", "N_col")
)

a_count_patients_with_flags(
  df,
  .var,
  flag_variables,
  .N_col,
  .N_row,
  denom = c("n", "N_row", "N_col")
)

count_patients_with_flags(
  lyt,
  var,
  var_labels = var,
  show_labels = "hidden",
  ...,
  table_names = paste0("tbl_flags_", var),
  .stats = "count_fraction",
  .formats = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{character})\cr name of the column that contains the unique identifier.}

\item{flag_variables}{(\code{character})\cr a character vector specifying the names of \code{logical}
variables from analysis dataset used for counting the number of unique identifiers.}

\item{.N_col}{(\code{count})\cr row-wise N (row group count) for the group of observations being analyzed
(i.e. with no column-based subsetting) that is passed by \code{rtables}.}

\item{.N_row}{(\code{count})\cr column-wise N (column count) for the full column that is passed by \code{rtables}.}

\item{denom}{(\code{string})\cr choice of denominator for proportion. Options are:
\itemize{
\item \code{n}: number of values in this row and column intersection.
\item \code{N_row}: total number of values in this row across columns.
\item \code{N_col}: total number of values in this column across rows.
}}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{var_labels}{(\code{character})\cr character for label.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
\itemize{
\item \code{s_count_patients_with_flags()} returns the count and the fraction of unique identifiers with each particular
flag as a list of statistics \code{n}, \code{count}, \code{count_fraction}, and \code{n_blq}, with one element per flag.
}

\itemize{
\item \code{a_count_patients_with_flags()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{count_patients_with_flags()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_patients_with_flags()} to the table layout.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The primary analysis variable \code{.var} denotes the unique patient identifier.
}
\section{Functions}{
\itemize{
\item \code{s_count_patients_with_flags()}: Statistics function which counts the number of patients for which
a particular flag variable is \code{TRUE}.

\item \code{a_count_patients_with_flags()}: Formatted analysis function which is used as \code{afun}
in \code{count_patients_with_flags()}.

\item \code{count_patients_with_flags()}: Layout-creating function which can take statistics function
arguments and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\examples{
library(dplyr)

# `s_count_patients_with_flags()`

# Add labelled flag variables to analysis dataset.
adae <- tern_ex_adae \%>\%
  mutate(
    fl1 = TRUE,
    fl2 = TRTEMFL == "Y",
    fl3 = TRTEMFL == "Y" & AEOUT == "FATAL",
    fl4 = TRTEMFL == "Y" & AEOUT == "FATAL" & AEREL == "Y"
  )
labels <- c(
  "fl1" = "Total AEs",
  "fl2" = "Total number of patients with at least one adverse event",
  "fl3" = "Total number of patients with fatal AEs",
  "fl4" = "Total number of patients with related fatal AEs"
)
formatters::var_labels(adae)[names(labels)] <- labels

s_count_patients_with_flags(
  adae,
  "SUBJID",
  flag_variables = c("fl1", "fl2", "fl3", "fl4"),
  denom = "N_col",
  .N_col = 1000
)

#  We need to ungroup `count_fraction` first so that the `rtables` formatting
# function `format_count_fraction()` can be applied correctly.

# `a_count_patients_with_flags()`

afun <- make_afun(a_count_patients_with_flags,
  .stats = "count_fraction",
  .ungroup_stats = "count_fraction"
)
afun(
  adae,
  .N_col = 10L,
  .N_row = 10L,
  .var = "USUBJID",
  flag_variables = c("fl1", "fl2", "fl3", "fl4")
)

# `count_patients_with_flags()`

lyt2 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  count_patients_with_flags(
    "SUBJID",
    flag_variables = formatters::var_labels(adae[, c("fl1", "fl2", "fl3", "fl4")]),
    denom = "N_col"
  )
build_table(lyt2, adae, alt_counts_df = tern_ex_adsl)

}
\seealso{
\link{count_patients_with_event}
}
