% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tenAR.r
\name{tenAR.sim}
\alias{tenAR.sim}
\title{Generate TenAR(p) tensor time series}
\usage{
tenAR.sim(t, dim, R, P, rho, cov, A = NULL)
}
\arguments{
\item{t}{length of output series, a strictly positive integer.}

\item{dim}{dimension of the tensor at each time.}

\item{R}{Kronecker rank for each lag.}

\item{P}{autoregressive order.}

\item{rho}{spectral radius of coefficient matrix \eqn{\Phi}.}

\item{cov}{covariance matrix of the error term: diagonal ("iid"), separable ("mle"), random ("svd").}

\item{A}{coefficient matrices. If not provided, they are randomly generated according to given \code{dim}, \code{R}, \code{P} and \code{rho}.
It is a multi-layer list, the first layer for the lag \eqn{1 \le i \le P}, the second the term \eqn{1 \le r \le R}, and the third the mode \eqn{1 \le k \le K}.
See "Details" of \code{\link{tenAR.est}}.}
}
\value{
A tensor-valued time series generated by the TenAR(p) model.
}
\description{
Simulate from the TenAR(p) model.
}
\examples{
set.seed(123)
dim <- c(3,3,3)
xx <- tenAR.sim(t=500, dim, R=2, P=1, rho=0.5, cov='iid')
}
\seealso{
\code{\link{tenFM.sim}}
}
