% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{coprecip.predict}
\alias{coprecip.predict}
\title{Sample composition sampling output for the RESP model}
\format{An stPredict object, which is a list of several objects
\describe{
  \item{pred}{A list containing summaries of posterior predictions}
  \item{samples}{Posterior samples for predictions}
  \item{coords.s}{centers of grid cells for Colorado data}
  \item{localOnly}{TRUE if remote covariates were not estimated}
  \item{varying}{(deprecated) TRUE if local covariates were estimated as a 
      spatially-varying field}
  \item{tLabs}{year labels for prediction timepoints}
  \item{Y.lab}{Label for response data, used by plotting functions}
  \item{cat.probs}{vector of probabilities for using posterior samples to 
    return categorical predictions from the posterior prediction samples}
  \item{category.breaks}{Breakpoints used to discretize posterior predictive
    distribution at each coordinate in coords.s during composition sampling.}
  \item{alpha_knots}{Summaries of posterior estimates of teleconnection 
    effects}
  \item{eof_alpha_knots}{Summaries of posterior estimates of teleconnection 
    effects after spatial basis function transformation}
}}
\usage{
coprecip.predict
}
\description{
An example stPredict object containing predictions from a short run of the 
MCMC composition sampler.  The output also contains teleconnection estimates.
}
\examples{

data("coprecip.predict")
str(coprecip.predict)

}
\keyword{datasets}
