% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{default_total_label}
\alias{default_total_label}
\alias{set_default_total_label}
\title{Default string for total column label}
\usage{
default_total_label()

set_default_total_label(total_label)
}
\arguments{
\item{total_label}{(\code{string})\cr Single string value to set in the R environment options as
the default label to use for the "total" column. Use \code{getOption("tmc_default_total_label")} to
check the current value set in the R environment (defaults to \code{"All Patients"} if not set).}
}
\value{
\itemize{
\item \code{default_total_label} returns the current value if an R environment option has been set
for \code{"tmc_default_total_label"}, or \code{"All Patients"} otherwise.
}

\itemize{
\item \code{set_default_total_label} has no return value.
}
}
\description{
The default string used as a label for the "total" column. This value is used as the default
value for the \code{total_label} argument throughout the \code{teal.modules.clinical} package. If not specified
for each module by the user via the \code{total_label} argument, or in the R environment options via
\code{\link[=set_default_total_label]{set_default_total_label()}}, then \code{"All Patients"} is used.
}
\section{Functions}{
\itemize{
\item \code{default_total_label()}: Getter for default total column label.

\item \code{set_default_total_label()}: Setter for default total column label. Sets the
option \code{"tmc_default_total_label"} within the R environment.

}}
\examples{
# Default settings
default_total_label()
getOption("tmc_default_total_label")

# Set custom value
set_default_total_label("All Patients")

# Settings after value has been set
default_total_label()
getOption("tmc_default_total_label")

}
