% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ui.R
\name{add_ui}
\alias{add_ui}
\title{Add the UI of one app within the UI of another app}
\usage{
add_ui(app, path)
}
\arguments{
\item{app}{Name of the app from which the content of the \code{ui.R} will be pulled}

\item{path}{Path to a directory containing the app from which the content of the \code{ui.R} will be pulled}
}
\value{
A list of length 2
\item{head}{A sub list containing the HTML content within the \code{<head>} tag}
\item{body}{A sub list containing the HTML content within the \code{<body>} tag}
}
\description{
Sources a \code{ui.R} file before parsing and evaluating its contents in a specified environment
}
\details{
Currently, this function can be used to insert an \code{server} into
         a \code{navbarPage} app.  The types of apps that can be inserted are:
     \itemize{
         \item{\code{fluidPage}}{}
         \item{\code{bootstrapPage}}{}
         \item{\code{pageWithSidebar}}{}
         \item{\code{basicPage}}{}
         \item{\code{fixedPage}}{}
      }
         
         A \code{server} can be added as an entire \code{tabPanel} or as a row within 
         within a \code{tabPanel} portion of a shiny app. 
         
         May be used with apps stored in packages other than teachingApps.  
         However, apps are assumed be stored in the \code{apps/} directory located 
         at top level of the package.
}
\examples{
\dontrun{

## ui.R from app: 'maximum_likelihood'

ui_ml <- system.file('apps', 
                     'maximum_likelihood',
                     'server.R',
                     package = 'teachingApps') 
browseURL(ui_ml)

## ui.R from app: 'distribution_weibull'

ui_dw <- system.file('apps', 
                     'distribution_weibull',
                     'server.R',
                     package = 'teachingApps') 
browseURL(ui_dw)

}
}
\seealso{
\code{\link{add_server}} \code{\link{add_rmd}}
}
